/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroupstaggingapi.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.ResourceGroupsTaggingApiResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeReportCreationResponse
extends ResourceGroupsTaggingApiResponse
implements ToCopyableBuilder<Builder, DescribeReportCreationResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeReportCreationResponse.getter(DescribeReportCreationResponse::status)).setter(DescribeReportCreationResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> S3_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Location").getter(DescribeReportCreationResponse.getter(DescribeReportCreationResponse::s3Location)).setter(DescribeReportCreationResponse.setter(Builder::s3Location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Location").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(DescribeReportCreationResponse.getter(DescribeReportCreationResponse::errorMessage)).setter(DescribeReportCreationResponse.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, S3_LOCATION_FIELD, ERROR_MESSAGE_FIELD));
    private final String status;
    private final String s3Location;
    private final String errorMessage;

    private DescribeReportCreationResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.s3Location = builder.s3Location;
        this.errorMessage = builder.errorMessage;
    }

    public final String status() {
        return this.status;
    }

    public final String s3Location() {
        return this.s3Location;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Location());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReportCreationResponse)) {
            return false;
        }
        DescribeReportCreationResponse other = (DescribeReportCreationResponse)((Object)obj);
        return Objects.equals(this.status(), other.status()) && Objects.equals(this.s3Location(), other.s3Location()) && Objects.equals(this.errorMessage(), other.errorMessage());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeReportCreationResponse").add("Status", (Object)this.status()).add("S3Location", (Object)this.s3Location()).add("ErrorMessage", (Object)this.errorMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "S3Location": {
                return Optional.ofNullable(clazz.cast(this.s3Location()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReportCreationResponse, T> g) {
        return obj -> g.apply((DescribeReportCreationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResourceGroupsTaggingApiResponse.BuilderImpl
    implements Builder {
        private String status;
        private String s3Location;
        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReportCreationResponse model) {
            super(model);
            this.status(model.status);
            this.s3Location(model.s3Location);
            this.errorMessage(model.errorMessage);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getS3Location() {
            return this.s3Location;
        }

        @Override
        public final Builder s3Location(String s3Location) {
            this.s3Location = s3Location;
            return this;
        }

        public final void setS3Location(String s3Location) {
            this.s3Location = s3Location;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public DescribeReportCreationResponse build() {
            return new DescribeReportCreationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ResourceGroupsTaggingApiResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeReportCreationResponse> {
        public Builder status(String var1);

        public Builder s3Location(String var1);

        public Builder errorMessage(String var1);
    }
}

