/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroupstaggingapi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.TagKeyListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComplianceDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComplianceDetails> {
    private static final SdkField<List<String>> NONCOMPLIANT_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NoncompliantKeys").getter(ComplianceDetails.getter(ComplianceDetails::noncompliantKeys)).setter(ComplianceDetails.setter(Builder::noncompliantKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoncompliantKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> KEYS_WITH_NONCOMPLIANT_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("KeysWithNoncompliantValues").getter(ComplianceDetails.getter(ComplianceDetails::keysWithNoncompliantValues)).setter(ComplianceDetails.setter(Builder::keysWithNoncompliantValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeysWithNoncompliantValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> COMPLIANCE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ComplianceStatus").getter(ComplianceDetails.getter(ComplianceDetails::complianceStatus)).setter(ComplianceDetails.setter(Builder::complianceStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NONCOMPLIANT_KEYS_FIELD, KEYS_WITH_NONCOMPLIANT_VALUES_FIELD, COMPLIANCE_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> noncompliantKeys;
    private final List<String> keysWithNoncompliantValues;
    private final Boolean complianceStatus;

    private ComplianceDetails(BuilderImpl builder) {
        this.noncompliantKeys = builder.noncompliantKeys;
        this.keysWithNoncompliantValues = builder.keysWithNoncompliantValues;
        this.complianceStatus = builder.complianceStatus;
    }

    public final boolean hasNoncompliantKeys() {
        return this.noncompliantKeys != null && !(this.noncompliantKeys instanceof SdkAutoConstructList);
    }

    public final List<String> noncompliantKeys() {
        return this.noncompliantKeys;
    }

    public final boolean hasKeysWithNoncompliantValues() {
        return this.keysWithNoncompliantValues != null && !(this.keysWithNoncompliantValues instanceof SdkAutoConstructList);
    }

    public final List<String> keysWithNoncompliantValues() {
        return this.keysWithNoncompliantValues;
    }

    public final Boolean complianceStatus() {
        return this.complianceStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNoncompliantKeys() ? this.noncompliantKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKeysWithNoncompliantValues() ? this.keysWithNoncompliantValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceStatus());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComplianceDetails)) {
            return false;
        }
        ComplianceDetails other = (ComplianceDetails)obj;
        return this.hasNoncompliantKeys() == other.hasNoncompliantKeys() && Objects.equals(this.noncompliantKeys(), other.noncompliantKeys()) && this.hasKeysWithNoncompliantValues() == other.hasKeysWithNoncompliantValues() && Objects.equals(this.keysWithNoncompliantValues(), other.keysWithNoncompliantValues()) && Objects.equals(this.complianceStatus(), other.complianceStatus());
    }

    public final String toString() {
        return ToString.builder((String)"ComplianceDetails").add("NoncompliantKeys", this.hasNoncompliantKeys() ? this.noncompliantKeys() : null).add("KeysWithNoncompliantValues", this.hasKeysWithNoncompliantValues() ? this.keysWithNoncompliantValues() : null).add("ComplianceStatus", (Object)this.complianceStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NoncompliantKeys": {
                return Optional.ofNullable(clazz.cast(this.noncompliantKeys()));
            }
            case "KeysWithNoncompliantValues": {
                return Optional.ofNullable(clazz.cast(this.keysWithNoncompliantValues()));
            }
            case "ComplianceStatus": {
                return Optional.ofNullable(clazz.cast(this.complianceStatus()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComplianceDetails, T> g) {
        return obj -> g.apply((ComplianceDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> noncompliantKeys = DefaultSdkAutoConstructList.getInstance();
        private List<String> keysWithNoncompliantValues = DefaultSdkAutoConstructList.getInstance();
        private Boolean complianceStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ComplianceDetails model) {
            this.noncompliantKeys(model.noncompliantKeys);
            this.keysWithNoncompliantValues(model.keysWithNoncompliantValues);
            this.complianceStatus(model.complianceStatus);
        }

        public final Collection<String> getNoncompliantKeys() {
            if (this.noncompliantKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return this.noncompliantKeys;
        }

        @Override
        public final Builder noncompliantKeys(Collection<String> noncompliantKeys) {
            this.noncompliantKeys = TagKeyListCopier.copy(noncompliantKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder noncompliantKeys(String ... noncompliantKeys) {
            this.noncompliantKeys(Arrays.asList(noncompliantKeys));
            return this;
        }

        public final void setNoncompliantKeys(Collection<String> noncompliantKeys) {
            this.noncompliantKeys = TagKeyListCopier.copy(noncompliantKeys);
        }

        public final Collection<String> getKeysWithNoncompliantValues() {
            if (this.keysWithNoncompliantValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.keysWithNoncompliantValues;
        }

        @Override
        public final Builder keysWithNoncompliantValues(Collection<String> keysWithNoncompliantValues) {
            this.keysWithNoncompliantValues = TagKeyListCopier.copy(keysWithNoncompliantValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keysWithNoncompliantValues(String ... keysWithNoncompliantValues) {
            this.keysWithNoncompliantValues(Arrays.asList(keysWithNoncompliantValues));
            return this;
        }

        public final void setKeysWithNoncompliantValues(Collection<String> keysWithNoncompliantValues) {
            this.keysWithNoncompliantValues = TagKeyListCopier.copy(keysWithNoncompliantValues);
        }

        public final Boolean getComplianceStatus() {
            return this.complianceStatus;
        }

        @Override
        public final Builder complianceStatus(Boolean complianceStatus) {
            this.complianceStatus = complianceStatus;
            return this;
        }

        public final void setComplianceStatus(Boolean complianceStatus) {
            this.complianceStatus = complianceStatus;
        }

        public ComplianceDetails build() {
            return new ComplianceDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComplianceDetails> {
        public Builder noncompliantKeys(Collection<String> var1);

        public Builder noncompliantKeys(String ... var1);

        public Builder keysWithNoncompliantValues(Collection<String> var1);

        public Builder keysWithNoncompliantValues(String ... var1);

        public Builder complianceStatus(Boolean var1);
    }
}

