/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroupstaggingapi;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.resourcegroupstaggingapi.ResourceGroupsTaggingApiClient;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.ConcurrentModificationException;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.ConstraintViolationException;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.DescribeReportCreationRequest;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.DescribeReportCreationResponse;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.GetComplianceSummaryRequest;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.GetComplianceSummaryResponse;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.GetResourcesRequest;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.GetResourcesResponse;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.GetTagKeysRequest;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.GetTagKeysResponse;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.GetTagValuesRequest;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.GetTagValuesResponse;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.InternalServiceException;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.InvalidParameterException;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.PaginationTokenExpiredException;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.ResourceGroupsTaggingApiException;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.ResourceGroupsTaggingApiRequest;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.StartReportCreationRequest;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.StartReportCreationResponse;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.TagResourcesRequest;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.TagResourcesResponse;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.ThrottledException;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.UntagResourcesRequest;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.UntagResourcesResponse;
import software.amazon.awssdk.services.resourcegroupstaggingapi.paginators.GetComplianceSummaryIterable;
import software.amazon.awssdk.services.resourcegroupstaggingapi.paginators.GetResourcesIterable;
import software.amazon.awssdk.services.resourcegroupstaggingapi.paginators.GetTagKeysIterable;
import software.amazon.awssdk.services.resourcegroupstaggingapi.paginators.GetTagValuesIterable;
import software.amazon.awssdk.services.resourcegroupstaggingapi.transform.DescribeReportCreationRequestMarshaller;
import software.amazon.awssdk.services.resourcegroupstaggingapi.transform.GetComplianceSummaryRequestMarshaller;
import software.amazon.awssdk.services.resourcegroupstaggingapi.transform.GetResourcesRequestMarshaller;
import software.amazon.awssdk.services.resourcegroupstaggingapi.transform.GetTagKeysRequestMarshaller;
import software.amazon.awssdk.services.resourcegroupstaggingapi.transform.GetTagValuesRequestMarshaller;
import software.amazon.awssdk.services.resourcegroupstaggingapi.transform.StartReportCreationRequestMarshaller;
import software.amazon.awssdk.services.resourcegroupstaggingapi.transform.TagResourcesRequestMarshaller;
import software.amazon.awssdk.services.resourcegroupstaggingapi.transform.UntagResourcesRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultResourceGroupsTaggingApiClient
implements ResourceGroupsTaggingApiClient {
    private static final Logger log = Logger.loggerFor(DefaultResourceGroupsTaggingApiClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultResourceGroupsTaggingApiClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "tagging";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeReportCreationResponse describeReportCreation(DescribeReportCreationRequest describeReportCreationRequest) throws ConstraintViolationException, InternalServiceException, InvalidParameterException, ThrottledException, AwsServiceException, SdkClientException, ResourceGroupsTaggingApiException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeReportCreationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultResourceGroupsTaggingApiClient.resolveMetricPublishers(this.clientConfiguration, describeReportCreationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Resource Groups Tagging API");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeReportCreation");
            DescribeReportCreationResponse describeReportCreationResponse = (DescribeReportCreationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReportCreation").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeReportCreationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeReportCreationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeReportCreationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultResourceGroupsTaggingApiClient.lambda$describeReportCreation$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetComplianceSummaryResponse getComplianceSummary(GetComplianceSummaryRequest getComplianceSummaryRequest) throws ConstraintViolationException, InternalServiceException, InvalidParameterException, ThrottledException, AwsServiceException, SdkClientException, ResourceGroupsTaggingApiException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetComplianceSummaryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultResourceGroupsTaggingApiClient.resolveMetricPublishers(this.clientConfiguration, getComplianceSummaryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Resource Groups Tagging API");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetComplianceSummary");
            GetComplianceSummaryResponse getComplianceSummaryResponse = (GetComplianceSummaryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetComplianceSummary").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getComplianceSummaryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetComplianceSummaryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getComplianceSummaryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultResourceGroupsTaggingApiClient.lambda$getComplianceSummary$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public GetComplianceSummaryIterable getComplianceSummaryPaginator(GetComplianceSummaryRequest getComplianceSummaryRequest) throws ConstraintViolationException, InternalServiceException, InvalidParameterException, ThrottledException, AwsServiceException, SdkClientException, ResourceGroupsTaggingApiException {
        return new GetComplianceSummaryIterable(this, this.applyPaginatorUserAgent(getComplianceSummaryRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetResourcesResponse getResources(GetResourcesRequest getResourcesRequest) throws InvalidParameterException, ThrottledException, InternalServiceException, PaginationTokenExpiredException, AwsServiceException, SdkClientException, ResourceGroupsTaggingApiException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetResourcesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultResourceGroupsTaggingApiClient.resolveMetricPublishers(this.clientConfiguration, getResourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Resource Groups Tagging API");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetResources");
            GetResourcesResponse getResourcesResponse = (GetResourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetResources").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getResourcesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetResourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getResourcesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultResourceGroupsTaggingApiClient.lambda$getResources$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public GetResourcesIterable getResourcesPaginator(GetResourcesRequest getResourcesRequest) throws InvalidParameterException, ThrottledException, InternalServiceException, PaginationTokenExpiredException, AwsServiceException, SdkClientException, ResourceGroupsTaggingApiException {
        return new GetResourcesIterable(this, this.applyPaginatorUserAgent(getResourcesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTagKeysResponse getTagKeys(GetTagKeysRequest getTagKeysRequest) throws InvalidParameterException, ThrottledException, InternalServiceException, PaginationTokenExpiredException, AwsServiceException, SdkClientException, ResourceGroupsTaggingApiException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTagKeysResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultResourceGroupsTaggingApiClient.resolveMetricPublishers(this.clientConfiguration, getTagKeysRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Resource Groups Tagging API");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTagKeys");
            GetTagKeysResponse getTagKeysResponse = (GetTagKeysResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTagKeys").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getTagKeysRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetTagKeysRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getTagKeysResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultResourceGroupsTaggingApiClient.lambda$getTagKeys$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public GetTagKeysIterable getTagKeysPaginator(GetTagKeysRequest getTagKeysRequest) throws InvalidParameterException, ThrottledException, InternalServiceException, PaginationTokenExpiredException, AwsServiceException, SdkClientException, ResourceGroupsTaggingApiException {
        return new GetTagKeysIterable(this, this.applyPaginatorUserAgent(getTagKeysRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTagValuesResponse getTagValues(GetTagValuesRequest getTagValuesRequest) throws InvalidParameterException, ThrottledException, InternalServiceException, PaginationTokenExpiredException, AwsServiceException, SdkClientException, ResourceGroupsTaggingApiException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTagValuesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultResourceGroupsTaggingApiClient.resolveMetricPublishers(this.clientConfiguration, getTagValuesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Resource Groups Tagging API");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTagValues");
            GetTagValuesResponse getTagValuesResponse = (GetTagValuesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTagValues").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getTagValuesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetTagValuesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getTagValuesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultResourceGroupsTaggingApiClient.lambda$getTagValues$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public GetTagValuesIterable getTagValuesPaginator(GetTagValuesRequest getTagValuesRequest) throws InvalidParameterException, ThrottledException, InternalServiceException, PaginationTokenExpiredException, AwsServiceException, SdkClientException, ResourceGroupsTaggingApiException {
        return new GetTagValuesIterable(this, this.applyPaginatorUserAgent(getTagValuesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartReportCreationResponse startReportCreation(StartReportCreationRequest startReportCreationRequest) throws ConcurrentModificationException, ConstraintViolationException, InternalServiceException, InvalidParameterException, ThrottledException, AwsServiceException, SdkClientException, ResourceGroupsTaggingApiException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartReportCreationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultResourceGroupsTaggingApiClient.resolveMetricPublishers(this.clientConfiguration, startReportCreationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Resource Groups Tagging API");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartReportCreation");
            StartReportCreationResponse startReportCreationResponse = (StartReportCreationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartReportCreation").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startReportCreationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartReportCreationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startReportCreationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultResourceGroupsTaggingApiClient.lambda$startReportCreation$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourcesResponse tagResources(TagResourcesRequest tagResourcesRequest) throws InvalidParameterException, ThrottledException, InternalServiceException, AwsServiceException, SdkClientException, ResourceGroupsTaggingApiException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourcesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultResourceGroupsTaggingApiClient.resolveMetricPublishers(this.clientConfiguration, tagResourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Resource Groups Tagging API");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResources");
            TagResourcesResponse tagResourcesResponse = (TagResourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResources").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourcesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourcesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultResourceGroupsTaggingApiClient.lambda$tagResources$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourcesResponse untagResources(UntagResourcesRequest untagResourcesRequest) throws InvalidParameterException, ThrottledException, InternalServiceException, AwsServiceException, SdkClientException, ResourceGroupsTaggingApiException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourcesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultResourceGroupsTaggingApiClient.resolveMetricPublishers(this.clientConfiguration, untagResourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Resource Groups Tagging API");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResources");
            UntagResourcesResponse untagResourcesResponse = (UntagResourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResources").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourcesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourcesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultResourceGroupsTaggingApiClient.lambda$untagResources$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(ResourceGroupsTaggingApiException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidParameterException").exceptionBuilderSupplier(InvalidParameterException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConstraintViolationException").exceptionBuilderSupplier(ConstraintViolationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottledException").exceptionBuilderSupplier(ThrottledException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServiceException").exceptionBuilderSupplier(InternalServiceException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PaginationTokenExpiredException").exceptionBuilderSupplier(PaginationTokenExpiredException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends ResourceGroupsTaggingApiRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.16.46").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((ResourceGroupsTaggingApiRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private static /* synthetic */ void lambda$untagResources$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResources$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startReportCreation$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTagValues$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTagKeys$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getResources$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getComplianceSummary$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeReportCreation$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

