/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rekognition.RekognitionAsyncClient;
import software.amazon.awssdk.services.rekognition.model.DescribeProjectsRequest;
import software.amazon.awssdk.services.rekognition.model.DescribeProjectsResponse;
import software.amazon.awssdk.services.rekognition.model.ProjectDescription;

public class DescribeProjectsPublisher
implements SdkPublisher<DescribeProjectsResponse> {
    private final RekognitionAsyncClient client;
    private final DescribeProjectsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeProjectsPublisher(RekognitionAsyncClient client, DescribeProjectsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeProjectsPublisher(RekognitionAsyncClient client, DescribeProjectsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeProjectsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeProjectsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ProjectDescription> projectDescriptions() {
        Function<DescribeProjectsResponse, Iterator> getIterator = response -> {
            if (response != null && response.projectDescriptions() != null) {
                return response.projectDescriptions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeProjectsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeProjectsResponseFetcher
    implements AsyncPageFetcher<DescribeProjectsResponse> {
        private DescribeProjectsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeProjectsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeProjectsResponse> nextPage(DescribeProjectsResponse previousPage) {
            if (previousPage == null) {
                return DescribeProjectsPublisher.this.client.describeProjects(DescribeProjectsPublisher.this.firstRequest);
            }
            return DescribeProjectsPublisher.this.client.describeProjects((DescribeProjectsRequest)((Object)DescribeProjectsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

