/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rdsdata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rdsdata.model.RdsDataRequest;
import software.amazon.awssdk.services.rdsdata.model.ResultSetOptions;
import software.amazon.awssdk.services.rdsdata.model.SqlParameter;
import software.amazon.awssdk.services.rdsdata.model.SqlParametersListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExecuteStatementRequest
extends RdsDataRequest
implements ToCopyableBuilder<Builder, ExecuteStatementRequest> {
    private static final SdkField<Boolean> CONTINUE_AFTER_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("continueAfterTimeout").getter(ExecuteStatementRequest.getter(ExecuteStatementRequest::continueAfterTimeout)).setter(ExecuteStatementRequest.setter(Builder::continueAfterTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("continueAfterTimeout").build()}).build();
    private static final SdkField<String> DATABASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("database").getter(ExecuteStatementRequest.getter(ExecuteStatementRequest::database)).setter(ExecuteStatementRequest.setter(Builder::database)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("database").build()}).build();
    private static final SdkField<Boolean> INCLUDE_RESULT_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("includeResultMetadata").getter(ExecuteStatementRequest.getter(ExecuteStatementRequest::includeResultMetadata)).setter(ExecuteStatementRequest.setter(Builder::includeResultMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeResultMetadata").build()}).build();
    private static final SdkField<List<SqlParameter>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("parameters").getter(ExecuteStatementRequest.getter(ExecuteStatementRequest::parameters)).setter(ExecuteStatementRequest.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SqlParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceArn").getter(ExecuteStatementRequest.getter(ExecuteStatementRequest::resourceArn)).setter(ExecuteStatementRequest.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()}).build();
    private static final SdkField<ResultSetOptions> RESULT_SET_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resultSetOptions").getter(ExecuteStatementRequest.getter(ExecuteStatementRequest::resultSetOptions)).setter(ExecuteStatementRequest.setter(Builder::resultSetOptions)).constructor(ResultSetOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resultSetOptions").build()}).build();
    private static final SdkField<String> SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("schema").getter(ExecuteStatementRequest.getter(ExecuteStatementRequest::schema)).setter(ExecuteStatementRequest.setter(Builder::schema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schema").build()}).build();
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("secretArn").getter(ExecuteStatementRequest.getter(ExecuteStatementRequest::secretArn)).setter(ExecuteStatementRequest.setter(Builder::secretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretArn").build()}).build();
    private static final SdkField<String> SQL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sql").getter(ExecuteStatementRequest.getter(ExecuteStatementRequest::sql)).setter(ExecuteStatementRequest.setter(Builder::sql)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sql").build()}).build();
    private static final SdkField<String> TRANSACTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("transactionId").getter(ExecuteStatementRequest.getter(ExecuteStatementRequest::transactionId)).setter(ExecuteStatementRequest.setter(Builder::transactionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transactionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTINUE_AFTER_TIMEOUT_FIELD, DATABASE_FIELD, INCLUDE_RESULT_METADATA_FIELD, PARAMETERS_FIELD, RESOURCE_ARN_FIELD, RESULT_SET_OPTIONS_FIELD, SCHEMA_FIELD, SECRET_ARN_FIELD, SQL_FIELD, TRANSACTION_ID_FIELD));
    private final Boolean continueAfterTimeout;
    private final String database;
    private final Boolean includeResultMetadata;
    private final List<SqlParameter> parameters;
    private final String resourceArn;
    private final ResultSetOptions resultSetOptions;
    private final String schema;
    private final String secretArn;
    private final String sql;
    private final String transactionId;

    private ExecuteStatementRequest(BuilderImpl builder) {
        super(builder);
        this.continueAfterTimeout = builder.continueAfterTimeout;
        this.database = builder.database;
        this.includeResultMetadata = builder.includeResultMetadata;
        this.parameters = builder.parameters;
        this.resourceArn = builder.resourceArn;
        this.resultSetOptions = builder.resultSetOptions;
        this.schema = builder.schema;
        this.secretArn = builder.secretArn;
        this.sql = builder.sql;
        this.transactionId = builder.transactionId;
    }

    public final Boolean continueAfterTimeout() {
        return this.continueAfterTimeout;
    }

    public final String database() {
        return this.database;
    }

    public final Boolean includeResultMetadata() {
        return this.includeResultMetadata;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructList);
    }

    public final List<SqlParameter> parameters() {
        return this.parameters;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final ResultSetOptions resultSetOptions() {
        return this.resultSetOptions;
    }

    public final String schema() {
        return this.schema;
    }

    public final String secretArn() {
        return this.secretArn;
    }

    public final String sql() {
        return this.sql;
    }

    public final String transactionId() {
        return this.transactionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.continueAfterTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.database());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeResultMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultSetOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.schema());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sql());
        hashCode = 31 * hashCode + Objects.hashCode(this.transactionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteStatementRequest)) {
            return false;
        }
        ExecuteStatementRequest other = (ExecuteStatementRequest)((Object)obj);
        return Objects.equals(this.continueAfterTimeout(), other.continueAfterTimeout()) && Objects.equals(this.database(), other.database()) && Objects.equals(this.includeResultMetadata(), other.includeResultMetadata()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.resultSetOptions(), other.resultSetOptions()) && Objects.equals(this.schema(), other.schema()) && Objects.equals(this.secretArn(), other.secretArn()) && Objects.equals(this.sql(), other.sql()) && Objects.equals(this.transactionId(), other.transactionId());
    }

    public final String toString() {
        return ToString.builder((String)"ExecuteStatementRequest").add("ContinueAfterTimeout", (Object)this.continueAfterTimeout()).add("Database", (Object)this.database()).add("IncludeResultMetadata", (Object)this.includeResultMetadata()).add("Parameters", this.hasParameters() ? this.parameters() : null).add("ResourceArn", (Object)this.resourceArn()).add("ResultSetOptions", (Object)this.resultSetOptions()).add("Schema", (Object)this.schema()).add("SecretArn", (Object)this.secretArn()).add("Sql", (Object)this.sql()).add("TransactionId", (Object)this.transactionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "continueAfterTimeout": {
                return Optional.ofNullable(clazz.cast(this.continueAfterTimeout()));
            }
            case "database": {
                return Optional.ofNullable(clazz.cast(this.database()));
            }
            case "includeResultMetadata": {
                return Optional.ofNullable(clazz.cast(this.includeResultMetadata()));
            }
            case "parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "resourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "resultSetOptions": {
                return Optional.ofNullable(clazz.cast(this.resultSetOptions()));
            }
            case "schema": {
                return Optional.ofNullable(clazz.cast(this.schema()));
            }
            case "secretArn": {
                return Optional.ofNullable(clazz.cast(this.secretArn()));
            }
            case "sql": {
                return Optional.ofNullable(clazz.cast(this.sql()));
            }
            case "transactionId": {
                return Optional.ofNullable(clazz.cast(this.transactionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecuteStatementRequest, T> g) {
        return obj -> g.apply((ExecuteStatementRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsDataRequest.BuilderImpl
    implements Builder {
        private Boolean continueAfterTimeout;
        private String database;
        private Boolean includeResultMetadata;
        private List<SqlParameter> parameters = DefaultSdkAutoConstructList.getInstance();
        private String resourceArn;
        private ResultSetOptions resultSetOptions;
        private String schema;
        private String secretArn;
        private String sql;
        private String transactionId;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteStatementRequest model) {
            super(model);
            this.continueAfterTimeout(model.continueAfterTimeout);
            this.database(model.database);
            this.includeResultMetadata(model.includeResultMetadata);
            this.parameters(model.parameters);
            this.resourceArn(model.resourceArn);
            this.resultSetOptions(model.resultSetOptions);
            this.schema(model.schema);
            this.secretArn(model.secretArn);
            this.sql(model.sql);
            this.transactionId(model.transactionId);
        }

        public final Boolean getContinueAfterTimeout() {
            return this.continueAfterTimeout;
        }

        @Override
        public final Builder continueAfterTimeout(Boolean continueAfterTimeout) {
            this.continueAfterTimeout = continueAfterTimeout;
            return this;
        }

        public final void setContinueAfterTimeout(Boolean continueAfterTimeout) {
            this.continueAfterTimeout = continueAfterTimeout;
        }

        public final String getDatabase() {
            return this.database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        public final Boolean getIncludeResultMetadata() {
            return this.includeResultMetadata;
        }

        @Override
        public final Builder includeResultMetadata(Boolean includeResultMetadata) {
            this.includeResultMetadata = includeResultMetadata;
            return this;
        }

        public final void setIncludeResultMetadata(Boolean includeResultMetadata) {
            this.includeResultMetadata = includeResultMetadata;
        }

        public final List<SqlParameter.Builder> getParameters() {
            List<SqlParameter.Builder> result = SqlParametersListCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder parameters(Collection<SqlParameter> parameters) {
            this.parameters = SqlParametersListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(SqlParameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<SqlParameter.Builder> ... parameters) {
            this.parameters(Stream.of(parameters).map(c -> (SqlParameter)((SqlParameter.Builder)SqlParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setParameters(Collection<SqlParameter.BuilderImpl> parameters) {
            this.parameters = SqlParametersListCopier.copyFromBuilder(parameters);
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final ResultSetOptions.Builder getResultSetOptions() {
            return this.resultSetOptions != null ? this.resultSetOptions.toBuilder() : null;
        }

        @Override
        public final Builder resultSetOptions(ResultSetOptions resultSetOptions) {
            this.resultSetOptions = resultSetOptions;
            return this;
        }

        public final void setResultSetOptions(ResultSetOptions.BuilderImpl resultSetOptions) {
            this.resultSetOptions = resultSetOptions != null ? resultSetOptions.build() : null;
        }

        public final String getSchema() {
            return this.schema;
        }

        @Override
        public final Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public final void setSchema(String schema) {
            this.schema = schema;
        }

        public final String getSecretArn() {
            return this.secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        public final String getSql() {
            return this.sql;
        }

        @Override
        public final Builder sql(String sql) {
            this.sql = sql;
            return this;
        }

        public final void setSql(String sql) {
            this.sql = sql;
        }

        public final String getTransactionId() {
            return this.transactionId;
        }

        @Override
        public final Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public final void setTransactionId(String transactionId) {
            this.transactionId = transactionId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExecuteStatementRequest build() {
            return new ExecuteStatementRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsDataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ExecuteStatementRequest> {
        public Builder continueAfterTimeout(Boolean var1);

        public Builder database(String var1);

        public Builder includeResultMetadata(Boolean var1);

        public Builder parameters(Collection<SqlParameter> var1);

        public Builder parameters(SqlParameter ... var1);

        public Builder parameters(Consumer<SqlParameter.Builder> ... var1);

        public Builder resourceArn(String var1);

        public Builder resultSetOptions(ResultSetOptions var1);

        default public Builder resultSetOptions(Consumer<ResultSetOptions.Builder> resultSetOptions) {
            return this.resultSetOptions((ResultSetOptions)((ResultSetOptions.Builder)ResultSetOptions.builder().applyMutation(resultSetOptions)).build());
        }

        public Builder schema(String var1);

        public Builder secretArn(String var1);

        public Builder sql(String var1);

        public Builder transactionId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

