/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rds.model.InstallationMediaFailureCause;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstallationMedia
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstallationMedia> {
    private static final SdkField<String> INSTALLATION_MEDIA_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstallationMediaId").getter(InstallationMedia.getter(InstallationMedia::installationMediaId)).setter(InstallationMedia.setter(Builder::installationMediaId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstallationMediaId").build()}).build();
    private static final SdkField<String> CUSTOM_AVAILABILITY_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomAvailabilityZoneId").getter(InstallationMedia.getter(InstallationMedia::customAvailabilityZoneId)).setter(InstallationMedia.setter(Builder::customAvailabilityZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomAvailabilityZoneId").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(InstallationMedia.getter(InstallationMedia::engine)).setter(InstallationMedia.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(InstallationMedia.getter(InstallationMedia::engineVersion)).setter(InstallationMedia.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<String> ENGINE_INSTALLATION_MEDIA_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineInstallationMediaPath").getter(InstallationMedia.getter(InstallationMedia::engineInstallationMediaPath)).setter(InstallationMedia.setter(Builder::engineInstallationMediaPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineInstallationMediaPath").build()}).build();
    private static final SdkField<String> OS_INSTALLATION_MEDIA_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OSInstallationMediaPath").getter(InstallationMedia.getter(InstallationMedia::osInstallationMediaPath)).setter(InstallationMedia.setter(Builder::osInstallationMediaPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OSInstallationMediaPath").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(InstallationMedia.getter(InstallationMedia::status)).setter(InstallationMedia.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<InstallationMediaFailureCause> FAILURE_CAUSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FailureCause").getter(InstallationMedia.getter(InstallationMedia::failureCause)).setter(InstallationMedia.setter(Builder::failureCause)).constructor(InstallationMediaFailureCause::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureCause").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTALLATION_MEDIA_ID_FIELD, CUSTOM_AVAILABILITY_ZONE_ID_FIELD, ENGINE_FIELD, ENGINE_VERSION_FIELD, ENGINE_INSTALLATION_MEDIA_PATH_FIELD, OS_INSTALLATION_MEDIA_PATH_FIELD, STATUS_FIELD, FAILURE_CAUSE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String installationMediaId;
    private final String customAvailabilityZoneId;
    private final String engine;
    private final String engineVersion;
    private final String engineInstallationMediaPath;
    private final String osInstallationMediaPath;
    private final String status;
    private final InstallationMediaFailureCause failureCause;

    private InstallationMedia(BuilderImpl builder) {
        this.installationMediaId = builder.installationMediaId;
        this.customAvailabilityZoneId = builder.customAvailabilityZoneId;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.engineInstallationMediaPath = builder.engineInstallationMediaPath;
        this.osInstallationMediaPath = builder.osInstallationMediaPath;
        this.status = builder.status;
        this.failureCause = builder.failureCause;
    }

    public final String installationMediaId() {
        return this.installationMediaId;
    }

    public final String customAvailabilityZoneId() {
        return this.customAvailabilityZoneId;
    }

    public final String engine() {
        return this.engine;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final String engineInstallationMediaPath() {
        return this.engineInstallationMediaPath;
    }

    public final String osInstallationMediaPath() {
        return this.osInstallationMediaPath;
    }

    public final String status() {
        return this.status;
    }

    public final InstallationMediaFailureCause failureCause() {
        return this.failureCause;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.installationMediaId());
        hashCode = 31 * hashCode + Objects.hashCode(this.customAvailabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineInstallationMediaPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.osInstallationMediaPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureCause());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstallationMedia)) {
            return false;
        }
        InstallationMedia other = (InstallationMedia)obj;
        return Objects.equals(this.installationMediaId(), other.installationMediaId()) && Objects.equals(this.customAvailabilityZoneId(), other.customAvailabilityZoneId()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.engineInstallationMediaPath(), other.engineInstallationMediaPath()) && Objects.equals(this.osInstallationMediaPath(), other.osInstallationMediaPath()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.failureCause(), other.failureCause());
    }

    public final String toString() {
        return ToString.builder((String)"InstallationMedia").add("InstallationMediaId", (Object)this.installationMediaId()).add("CustomAvailabilityZoneId", (Object)this.customAvailabilityZoneId()).add("Engine", (Object)this.engine()).add("EngineVersion", (Object)this.engineVersion()).add("EngineInstallationMediaPath", (Object)this.engineInstallationMediaPath()).add("OSInstallationMediaPath", (Object)this.osInstallationMediaPath()).add("Status", (Object)this.status()).add("FailureCause", (Object)this.failureCause()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstallationMediaId": {
                return Optional.ofNullable(clazz.cast(this.installationMediaId()));
            }
            case "CustomAvailabilityZoneId": {
                return Optional.ofNullable(clazz.cast(this.customAvailabilityZoneId()));
            }
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "EngineInstallationMediaPath": {
                return Optional.ofNullable(clazz.cast(this.engineInstallationMediaPath()));
            }
            case "OSInstallationMediaPath": {
                return Optional.ofNullable(clazz.cast(this.osInstallationMediaPath()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "FailureCause": {
                return Optional.ofNullable(clazz.cast(this.failureCause()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstallationMedia, T> g) {
        return obj -> g.apply((InstallationMedia)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String installationMediaId;
        private String customAvailabilityZoneId;
        private String engine;
        private String engineVersion;
        private String engineInstallationMediaPath;
        private String osInstallationMediaPath;
        private String status;
        private InstallationMediaFailureCause failureCause;

        private BuilderImpl() {
        }

        private BuilderImpl(InstallationMedia model) {
            this.installationMediaId(model.installationMediaId);
            this.customAvailabilityZoneId(model.customAvailabilityZoneId);
            this.engine(model.engine);
            this.engineVersion(model.engineVersion);
            this.engineInstallationMediaPath(model.engineInstallationMediaPath);
            this.osInstallationMediaPath(model.osInstallationMediaPath);
            this.status(model.status);
            this.failureCause(model.failureCause);
        }

        public final String getInstallationMediaId() {
            return this.installationMediaId;
        }

        @Override
        public final Builder installationMediaId(String installationMediaId) {
            this.installationMediaId = installationMediaId;
            return this;
        }

        public final void setInstallationMediaId(String installationMediaId) {
            this.installationMediaId = installationMediaId;
        }

        public final String getCustomAvailabilityZoneId() {
            return this.customAvailabilityZoneId;
        }

        @Override
        public final Builder customAvailabilityZoneId(String customAvailabilityZoneId) {
            this.customAvailabilityZoneId = customAvailabilityZoneId;
            return this;
        }

        public final void setCustomAvailabilityZoneId(String customAvailabilityZoneId) {
            this.customAvailabilityZoneId = customAvailabilityZoneId;
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final String getEngineInstallationMediaPath() {
            return this.engineInstallationMediaPath;
        }

        @Override
        public final Builder engineInstallationMediaPath(String engineInstallationMediaPath) {
            this.engineInstallationMediaPath = engineInstallationMediaPath;
            return this;
        }

        public final void setEngineInstallationMediaPath(String engineInstallationMediaPath) {
            this.engineInstallationMediaPath = engineInstallationMediaPath;
        }

        public final String getOsInstallationMediaPath() {
            return this.osInstallationMediaPath;
        }

        @Override
        public final Builder osInstallationMediaPath(String osInstallationMediaPath) {
            this.osInstallationMediaPath = osInstallationMediaPath;
            return this;
        }

        public final void setOsInstallationMediaPath(String osInstallationMediaPath) {
            this.osInstallationMediaPath = osInstallationMediaPath;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final InstallationMediaFailureCause.Builder getFailureCause() {
            return this.failureCause != null ? this.failureCause.toBuilder() : null;
        }

        @Override
        public final Builder failureCause(InstallationMediaFailureCause failureCause) {
            this.failureCause = failureCause;
            return this;
        }

        public final void setFailureCause(InstallationMediaFailureCause.BuilderImpl failureCause) {
            this.failureCause = failureCause != null ? failureCause.build() : null;
        }

        public InstallationMedia build() {
            return new InstallationMedia(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstallationMedia> {
        public Builder installationMediaId(String var1);

        public Builder customAvailabilityZoneId(String var1);

        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder engineInstallationMediaPath(String var1);

        public Builder osInstallationMediaPath(String var1);

        public Builder status(String var1);

        public Builder failureCause(InstallationMediaFailureCause var1);

        default public Builder failureCause(Consumer<InstallationMediaFailureCause.Builder> failureCause) {
            return this.failureCause((InstallationMediaFailureCause)((InstallationMediaFailureCause.Builder)InstallationMediaFailureCause.builder().applyMutation(failureCause)).build());
        }
    }
}

