/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rds.model.FailoverStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FailoverState
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FailoverState> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(FailoverState.getter(FailoverState::statusAsString)).setter(FailoverState.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> FROM_DB_CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FromDbClusterArn").getter(FailoverState.getter(FailoverState::fromDbClusterArn)).setter(FailoverState.setter(Builder::fromDbClusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromDbClusterArn").build()}).build();
    private static final SdkField<String> TO_DB_CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ToDbClusterArn").getter(FailoverState.getter(FailoverState::toDbClusterArn)).setter(FailoverState.setter(Builder::toDbClusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToDbClusterArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, FROM_DB_CLUSTER_ARN_FIELD, TO_DB_CLUSTER_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String status;
    private final String fromDbClusterArn;
    private final String toDbClusterArn;

    private FailoverState(BuilderImpl builder) {
        this.status = builder.status;
        this.fromDbClusterArn = builder.fromDbClusterArn;
        this.toDbClusterArn = builder.toDbClusterArn;
    }

    public final FailoverStatus status() {
        return FailoverStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String fromDbClusterArn() {
        return this.fromDbClusterArn;
    }

    public final String toDbClusterArn() {
        return this.toDbClusterArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fromDbClusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.toDbClusterArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailoverState)) {
            return false;
        }
        FailoverState other = (FailoverState)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.fromDbClusterArn(), other.fromDbClusterArn()) && Objects.equals(this.toDbClusterArn(), other.toDbClusterArn());
    }

    public final String toString() {
        return ToString.builder((String)"FailoverState").add("Status", (Object)this.statusAsString()).add("FromDbClusterArn", (Object)this.fromDbClusterArn()).add("ToDbClusterArn", (Object)this.toDbClusterArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "FromDbClusterArn": {
                return Optional.ofNullable(clazz.cast(this.fromDbClusterArn()));
            }
            case "ToDbClusterArn": {
                return Optional.ofNullable(clazz.cast(this.toDbClusterArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FailoverState, T> g) {
        return obj -> g.apply((FailoverState)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private String fromDbClusterArn;
        private String toDbClusterArn;

        private BuilderImpl() {
        }

        private BuilderImpl(FailoverState model) {
            this.status(model.status);
            this.fromDbClusterArn(model.fromDbClusterArn);
            this.toDbClusterArn(model.toDbClusterArn);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FailoverStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getFromDbClusterArn() {
            return this.fromDbClusterArn;
        }

        @Override
        public final Builder fromDbClusterArn(String fromDbClusterArn) {
            this.fromDbClusterArn = fromDbClusterArn;
            return this;
        }

        public final void setFromDbClusterArn(String fromDbClusterArn) {
            this.fromDbClusterArn = fromDbClusterArn;
        }

        public final String getToDbClusterArn() {
            return this.toDbClusterArn;
        }

        @Override
        public final Builder toDbClusterArn(String toDbClusterArn) {
            this.toDbClusterArn = toDbClusterArn;
            return this;
        }

        public final void setToDbClusterArn(String toDbClusterArn) {
            this.toDbClusterArn = toDbClusterArn;
        }

        public FailoverState build() {
            return new FailoverState(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FailoverState> {
        public Builder status(String var1);

        public Builder status(FailoverStatus var1);

        public Builder fromDbClusterArn(String var1);

        public Builder toDbClusterArn(String var1);
    }
}

