/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum SegmentType {
    DIMENSIONAL("DIMENSIONAL"),
    IMPORT("IMPORT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private SegmentType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SegmentType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(SegmentType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SegmentType> knownValues() {
        return Stream.of(SegmentType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

