/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AttributeType {
    INCLUSIVE("INCLUSIVE"),
    EXCLUSIVE("EXCLUSIVE"),
    CONTAINS("CONTAINS"),
    BEFORE("BEFORE"),
    AFTER("AFTER"),
    ON("ON"),
    BETWEEN("BETWEEN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AttributeType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AttributeType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AttributeType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AttributeType> knownValues() {
        return Stream.of(AttributeType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

