/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pi.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pi.model.MetricQuery;
import software.amazon.awssdk.services.pi.model.MetricQueryListCopier;
import software.amazon.awssdk.services.pi.model.PiRequest;
import software.amazon.awssdk.services.pi.model.ServiceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetResourceMetricsRequest
extends PiRequest
implements ToCopyableBuilder<Builder, GetResourceMetricsRequest> {
    private static final SdkField<String> SERVICE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceType").getter(GetResourceMetricsRequest.getter(GetResourceMetricsRequest::serviceTypeAsString)).setter(GetResourceMetricsRequest.setter(Builder::serviceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceType").build()}).build();
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Identifier").getter(GetResourceMetricsRequest.getter(GetResourceMetricsRequest::identifier)).setter(GetResourceMetricsRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()}).build();
    private static final SdkField<List<MetricQuery>> METRIC_QUERIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricQueries").getter(GetResourceMetricsRequest.getter(GetResourceMetricsRequest::metricQueries)).setter(GetResourceMetricsRequest.setter(Builder::metricQueries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricQueries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricQuery::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(GetResourceMetricsRequest.getter(GetResourceMetricsRequest::startTime)).setter(GetResourceMetricsRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(GetResourceMetricsRequest.getter(GetResourceMetricsRequest::endTime)).setter(GetResourceMetricsRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<Integer> PERIOD_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PeriodInSeconds").getter(GetResourceMetricsRequest.getter(GetResourceMetricsRequest::periodInSeconds)).setter(GetResourceMetricsRequest.setter(Builder::periodInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeriodInSeconds").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(GetResourceMetricsRequest.getter(GetResourceMetricsRequest::maxResults)).setter(GetResourceMetricsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetResourceMetricsRequest.getter(GetResourceMetricsRequest::nextToken)).setter(GetResourceMetricsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_TYPE_FIELD, IDENTIFIER_FIELD, METRIC_QUERIES_FIELD, START_TIME_FIELD, END_TIME_FIELD, PERIOD_IN_SECONDS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final String serviceType;
    private final String identifier;
    private final List<MetricQuery> metricQueries;
    private final Instant startTime;
    private final Instant endTime;
    private final Integer periodInSeconds;
    private final Integer maxResults;
    private final String nextToken;

    private GetResourceMetricsRequest(BuilderImpl builder) {
        super(builder);
        this.serviceType = builder.serviceType;
        this.identifier = builder.identifier;
        this.metricQueries = builder.metricQueries;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.periodInSeconds = builder.periodInSeconds;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final ServiceType serviceType() {
        return ServiceType.fromValue(this.serviceType);
    }

    public final String serviceTypeAsString() {
        return this.serviceType;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final boolean hasMetricQueries() {
        return this.metricQueries != null && !(this.metricQueries instanceof SdkAutoConstructList);
    }

    public final List<MetricQuery> metricQueries() {
        return this.metricQueries;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final Integer periodInSeconds() {
        return this.periodInSeconds;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricQueries() ? this.metricQueries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.periodInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceMetricsRequest)) {
            return false;
        }
        GetResourceMetricsRequest other = (GetResourceMetricsRequest)((Object)obj);
        return Objects.equals(this.serviceTypeAsString(), other.serviceTypeAsString()) && Objects.equals(this.identifier(), other.identifier()) && this.hasMetricQueries() == other.hasMetricQueries() && Objects.equals(this.metricQueries(), other.metricQueries()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.periodInSeconds(), other.periodInSeconds()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetResourceMetricsRequest").add("ServiceType", (Object)this.serviceTypeAsString()).add("Identifier", (Object)this.identifier()).add("MetricQueries", this.hasMetricQueries() ? this.metricQueries() : null).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("PeriodInSeconds", (Object)this.periodInSeconds()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceType": {
                return Optional.ofNullable(clazz.cast(this.serviceTypeAsString()));
            }
            case "Identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "MetricQueries": {
                return Optional.ofNullable(clazz.cast(this.metricQueries()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "PeriodInSeconds": {
                return Optional.ofNullable(clazz.cast(this.periodInSeconds()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetResourceMetricsRequest, T> g) {
        return obj -> g.apply((GetResourceMetricsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PiRequest.BuilderImpl
    implements Builder {
        private String serviceType;
        private String identifier;
        private List<MetricQuery> metricQueries = DefaultSdkAutoConstructList.getInstance();
        private Instant startTime;
        private Instant endTime;
        private Integer periodInSeconds;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceMetricsRequest model) {
            super(model);
            this.serviceType(model.serviceType);
            this.identifier(model.identifier);
            this.metricQueries(model.metricQueries);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.periodInSeconds(model.periodInSeconds);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getServiceType() {
            return this.serviceType;
        }

        @Override
        public final Builder serviceType(String serviceType) {
            this.serviceType = serviceType;
            return this;
        }

        @Override
        public final Builder serviceType(ServiceType serviceType) {
            this.serviceType(serviceType == null ? null : serviceType.toString());
            return this;
        }

        public final void setServiceType(String serviceType) {
            this.serviceType = serviceType;
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        public final List<MetricQuery.Builder> getMetricQueries() {
            List<MetricQuery.Builder> result = MetricQueryListCopier.copyToBuilder(this.metricQueries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder metricQueries(Collection<MetricQuery> metricQueries) {
            this.metricQueries = MetricQueryListCopier.copy(metricQueries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricQueries(MetricQuery ... metricQueries) {
            this.metricQueries(Arrays.asList(metricQueries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricQueries(Consumer<MetricQuery.Builder> ... metricQueries) {
            this.metricQueries(Stream.of(metricQueries).map(c -> (MetricQuery)((MetricQuery.Builder)MetricQuery.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMetricQueries(Collection<MetricQuery.BuilderImpl> metricQueries) {
            this.metricQueries = MetricQueryListCopier.copyFromBuilder(metricQueries);
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Integer getPeriodInSeconds() {
            return this.periodInSeconds;
        }

        @Override
        public final Builder periodInSeconds(Integer periodInSeconds) {
            this.periodInSeconds = periodInSeconds;
            return this;
        }

        public final void setPeriodInSeconds(Integer periodInSeconds) {
            this.periodInSeconds = periodInSeconds;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetResourceMetricsRequest build() {
            return new GetResourceMetricsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PiRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetResourceMetricsRequest> {
        public Builder serviceType(String var1);

        public Builder serviceType(ServiceType var1);

        public Builder identifier(String var1);

        public Builder metricQueries(Collection<MetricQuery> var1);

        public Builder metricQueries(MetricQuery ... var1);

        public Builder metricQueries(Consumer<MetricQuery.Builder> ... var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder periodInSeconds(Integer var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

