/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkmanager.NetworkManagerClient;
import software.amazon.awssdk.services.networkmanager.model.GetLinkAssociationsRequest;
import software.amazon.awssdk.services.networkmanager.model.GetLinkAssociationsResponse;
import software.amazon.awssdk.services.networkmanager.model.LinkAssociation;

public class GetLinkAssociationsIterable
implements SdkIterable<GetLinkAssociationsResponse> {
    private final NetworkManagerClient client;
    private final GetLinkAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetLinkAssociationsIterable(NetworkManagerClient client, GetLinkAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetLinkAssociationsResponseFetcher();
    }

    public Iterator<GetLinkAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<LinkAssociation> linkAssociations() {
        Function<GetLinkAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.linkAssociations() != null) {
                return response.linkAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetLinkAssociationsResponseFetcher
    implements SyncPageFetcher<GetLinkAssociationsResponse> {
        private GetLinkAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(GetLinkAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetLinkAssociationsResponse nextPage(GetLinkAssociationsResponse previousPage) {
            if (previousPage == null) {
                return GetLinkAssociationsIterable.this.client.getLinkAssociations(GetLinkAssociationsIterable.this.firstRequest);
            }
            return GetLinkAssociationsIterable.this.client.getLinkAssociations((GetLinkAssociationsRequest)((Object)GetLinkAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

