/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkmanager.NetworkManagerAsyncClient;
import software.amazon.awssdk.services.networkmanager.model.DescribeGlobalNetworksRequest;
import software.amazon.awssdk.services.networkmanager.model.DescribeGlobalNetworksResponse;
import software.amazon.awssdk.services.networkmanager.model.GlobalNetwork;

public class DescribeGlobalNetworksPublisher
implements SdkPublisher<DescribeGlobalNetworksResponse> {
    private final NetworkManagerAsyncClient client;
    private final DescribeGlobalNetworksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeGlobalNetworksPublisher(NetworkManagerAsyncClient client, DescribeGlobalNetworksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeGlobalNetworksPublisher(NetworkManagerAsyncClient client, DescribeGlobalNetworksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeGlobalNetworksResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeGlobalNetworksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<GlobalNetwork> globalNetworks() {
        Function<DescribeGlobalNetworksResponse, Iterator> getIterator = response -> {
            if (response != null && response.globalNetworks() != null) {
                return response.globalNetworks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeGlobalNetworksResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeGlobalNetworksResponseFetcher
    implements AsyncPageFetcher<DescribeGlobalNetworksResponse> {
        private DescribeGlobalNetworksResponseFetcher() {
        }

        public boolean hasNextPage(DescribeGlobalNetworksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeGlobalNetworksResponse> nextPage(DescribeGlobalNetworksResponse previousPage) {
            if (previousPage == null) {
                return DescribeGlobalNetworksPublisher.this.client.describeGlobalNetworks(DescribeGlobalNetworksPublisher.this.firstRequest);
            }
            return DescribeGlobalNetworksPublisher.this.client.describeGlobalNetworks((DescribeGlobalNetworksRequest)((Object)DescribeGlobalNetworksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

