/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum HITReviewStatus {
    NOT_REVIEWED("NotReviewed"),
    MARKED_FOR_REVIEW("MarkedForReview"),
    REVIEWED_APPROPRIATE("ReviewedAppropriate"),
    REVIEWED_INAPPROPRIATE("ReviewedInappropriate"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private HITReviewStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HITReviewStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(HITReviewStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HITReviewStatus> knownValues() {
        return Stream.of(HITReviewStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

