/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum Comparator {
    LESS_THAN("LessThan"),
    LESS_THAN_OR_EQUAL_TO("LessThanOrEqualTo"),
    GREATER_THAN("GreaterThan"),
    GREATER_THAN_OR_EQUAL_TO("GreaterThanOrEqualTo"),
    EQUAL_TO("EqualTo"),
    NOT_EQUAL_TO("NotEqualTo"),
    EXISTS("Exists"),
    DOES_NOT_EXIST("DoesNotExist"),
    IN("In"),
    NOT_IN("NotIn"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private Comparator(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Comparator fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(Comparator.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Comparator> knownValues() {
        return Stream.of(Comparator.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

