/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.migrationhub.MigrationHubClient;
import software.amazon.awssdk.services.migrationhub.model.ListProgressUpdateStreamsRequest;
import software.amazon.awssdk.services.migrationhub.model.ListProgressUpdateStreamsResponse;
import software.amazon.awssdk.services.migrationhub.model.ProgressUpdateStreamSummary;

public class ListProgressUpdateStreamsIterable
implements SdkIterable<ListProgressUpdateStreamsResponse> {
    private final MigrationHubClient client;
    private final ListProgressUpdateStreamsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListProgressUpdateStreamsIterable(MigrationHubClient client, ListProgressUpdateStreamsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListProgressUpdateStreamsResponseFetcher();
    }

    public Iterator<ListProgressUpdateStreamsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ProgressUpdateStreamSummary> progressUpdateStreamSummaryList() {
        Function<ListProgressUpdateStreamsResponse, Iterator> getIterator = response -> {
            if (response != null && response.progressUpdateStreamSummaryList() != null) {
                return response.progressUpdateStreamSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListProgressUpdateStreamsResponseFetcher
    implements SyncPageFetcher<ListProgressUpdateStreamsResponse> {
        private ListProgressUpdateStreamsResponseFetcher() {
        }

        public boolean hasNextPage(ListProgressUpdateStreamsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListProgressUpdateStreamsResponse nextPage(ListProgressUpdateStreamsResponse previousPage) {
            if (previousPage == null) {
                return ListProgressUpdateStreamsIterable.this.client.listProgressUpdateStreams(ListProgressUpdateStreamsIterable.this.firstRequest);
            }
            return ListProgressUpdateStreamsIterable.this.client.listProgressUpdateStreams((ListProgressUpdateStreamsRequest)((Object)ListProgressUpdateStreamsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

