/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediatailor.model.MediaTailorRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeProgramRequest
extends MediaTailorRequest
implements ToCopyableBuilder<Builder, DescribeProgramRequest> {
    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelName").getter(DescribeProgramRequest.getter(DescribeProgramRequest::channelName)).setter(DescribeProgramRequest.setter(Builder::channelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("channelName").build()}).build();
    private static final SdkField<String> PROGRAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProgramName").getter(DescribeProgramRequest.getter(DescribeProgramRequest::programName)).setter(DescribeProgramRequest.setter(Builder::programName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("programName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_NAME_FIELD, PROGRAM_NAME_FIELD));
    private final String channelName;
    private final String programName;

    private DescribeProgramRequest(BuilderImpl builder) {
        super(builder);
        this.channelName = builder.channelName;
        this.programName = builder.programName;
    }

    public final String channelName() {
        return this.channelName;
    }

    public final String programName() {
        return this.programName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.programName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProgramRequest)) {
            return false;
        }
        DescribeProgramRequest other = (DescribeProgramRequest)((Object)obj);
        return Objects.equals(this.channelName(), other.channelName()) && Objects.equals(this.programName(), other.programName());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeProgramRequest").add("ChannelName", (Object)this.channelName()).add("ProgramName", (Object)this.programName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelName": {
                return Optional.ofNullable(clazz.cast(this.channelName()));
            }
            case "ProgramName": {
                return Optional.ofNullable(clazz.cast(this.programName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeProgramRequest, T> g) {
        return obj -> g.apply((DescribeProgramRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaTailorRequest.BuilderImpl
    implements Builder {
        private String channelName;
        private String programName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProgramRequest model) {
            super(model);
            this.channelName(model.channelName);
            this.programName(model.programName);
        }

        public final String getChannelName() {
            return this.channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        public final String getProgramName() {
            return this.programName;
        }

        @Override
        public final Builder programName(String programName) {
            this.programName = programName;
            return this;
        }

        public final void setProgramName(String programName) {
            this.programName = programName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeProgramRequest build() {
            return new DescribeProgramRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaTailorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeProgramRequest> {
        public Builder channelName(String var1);

        public Builder programName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

