/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediastoredata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediastoredata.model.MediaStoreDataResponse;
import software.amazon.awssdk.services.mediastoredata.model.StorageClass;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutObjectResponse
extends MediaStoreDataResponse
implements ToCopyableBuilder<Builder, PutObjectResponse> {
    private static final SdkField<String> CONTENT_SHA256_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentSHA256").getter(PutObjectResponse.getter(PutObjectResponse::contentSHA256)).setter(PutObjectResponse.setter(Builder::contentSHA256)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentSHA256").build()}).build();
    private static final SdkField<String> E_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ETag").getter(PutObjectResponse.getter(PutObjectResponse::eTag)).setter(PutObjectResponse.setter(Builder::eTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ETag").build()}).build();
    private static final SdkField<String> STORAGE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageClass").getter(PutObjectResponse.getter(PutObjectResponse::storageClassAsString)).setter(PutObjectResponse.setter(Builder::storageClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageClass").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_SHA256_FIELD, E_TAG_FIELD, STORAGE_CLASS_FIELD));
    private final String contentSHA256;
    private final String eTag;
    private final String storageClass;

    private PutObjectResponse(BuilderImpl builder) {
        super(builder);
        this.contentSHA256 = builder.contentSHA256;
        this.eTag = builder.eTag;
        this.storageClass = builder.storageClass;
    }

    public final String contentSHA256() {
        return this.contentSHA256;
    }

    public final String eTag() {
        return this.eTag;
    }

    public final StorageClass storageClass() {
        return StorageClass.fromValue(this.storageClass);
    }

    public final String storageClassAsString() {
        return this.storageClass;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.contentSHA256());
        hashCode = 31 * hashCode + Objects.hashCode(this.eTag());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageClassAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutObjectResponse)) {
            return false;
        }
        PutObjectResponse other = (PutObjectResponse)((Object)obj);
        return Objects.equals(this.contentSHA256(), other.contentSHA256()) && Objects.equals(this.eTag(), other.eTag()) && Objects.equals(this.storageClassAsString(), other.storageClassAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PutObjectResponse").add("ContentSHA256", (Object)this.contentSHA256()).add("ETag", (Object)this.eTag()).add("StorageClass", (Object)this.storageClassAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContentSHA256": {
                return Optional.ofNullable(clazz.cast(this.contentSHA256()));
            }
            case "ETag": {
                return Optional.ofNullable(clazz.cast(this.eTag()));
            }
            case "StorageClass": {
                return Optional.ofNullable(clazz.cast(this.storageClassAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutObjectResponse, T> g) {
        return obj -> g.apply((PutObjectResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaStoreDataResponse.BuilderImpl
    implements Builder {
        private String contentSHA256;
        private String eTag;
        private String storageClass;

        private BuilderImpl() {
        }

        private BuilderImpl(PutObjectResponse model) {
            super(model);
            this.contentSHA256(model.contentSHA256);
            this.eTag(model.eTag);
            this.storageClass(model.storageClass);
        }

        public final String getContentSHA256() {
            return this.contentSHA256;
        }

        @Override
        public final Builder contentSHA256(String contentSHA256) {
            this.contentSHA256 = contentSHA256;
            return this;
        }

        public final void setContentSHA256(String contentSHA256) {
            this.contentSHA256 = contentSHA256;
        }

        public final String getETag() {
            return this.eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        public final String getStorageClass() {
            return this.storageClass;
        }

        @Override
        public final Builder storageClass(String storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @Override
        public final Builder storageClass(StorageClass storageClass) {
            this.storageClass(storageClass == null ? null : storageClass.toString());
            return this;
        }

        public final void setStorageClass(String storageClass) {
            this.storageClass = storageClass;
        }

        @Override
        public PutObjectResponse build() {
            return new PutObjectResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaStoreDataResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutObjectResponse> {
        public Builder contentSHA256(String var1);

        public Builder eTag(String var1);

        public Builder storageClass(String var1);

        public Builder storageClass(StorageClass var1);
    }
}

