/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediastoredata;

import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.services.mediastoredata.DefaultMediaStoreDataAsyncClientBuilder;
import software.amazon.awssdk.services.mediastoredata.MediaStoreDataAsyncClientBuilder;
import software.amazon.awssdk.services.mediastoredata.model.DeleteObjectRequest;
import software.amazon.awssdk.services.mediastoredata.model.DeleteObjectResponse;
import software.amazon.awssdk.services.mediastoredata.model.DescribeObjectRequest;
import software.amazon.awssdk.services.mediastoredata.model.DescribeObjectResponse;
import software.amazon.awssdk.services.mediastoredata.model.GetObjectRequest;
import software.amazon.awssdk.services.mediastoredata.model.GetObjectResponse;
import software.amazon.awssdk.services.mediastoredata.model.ListItemsRequest;
import software.amazon.awssdk.services.mediastoredata.model.ListItemsResponse;
import software.amazon.awssdk.services.mediastoredata.model.PutObjectRequest;
import software.amazon.awssdk.services.mediastoredata.model.PutObjectResponse;
import software.amazon.awssdk.services.mediastoredata.paginators.ListItemsPublisher;

public interface MediaStoreDataAsyncClient
extends SdkClient {
    public static final String SERVICE_NAME = "mediastore";
    public static final String SERVICE_METADATA_ID = "data.mediastore";

    public static MediaStoreDataAsyncClient create() {
        return (MediaStoreDataAsyncClient)MediaStoreDataAsyncClient.builder().build();
    }

    public static MediaStoreDataAsyncClientBuilder builder() {
        return new DefaultMediaStoreDataAsyncClientBuilder();
    }

    default public CompletableFuture<DeleteObjectResponse> deleteObject(DeleteObjectRequest deleteObjectRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DeleteObjectResponse> deleteObject(Consumer<DeleteObjectRequest.Builder> deleteObjectRequest) {
        return this.deleteObject((DeleteObjectRequest)((Object)((DeleteObjectRequest.Builder)DeleteObjectRequest.builder().applyMutation(deleteObjectRequest)).build()));
    }

    default public CompletableFuture<DescribeObjectResponse> describeObject(DescribeObjectRequest describeObjectRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DescribeObjectResponse> describeObject(Consumer<DescribeObjectRequest.Builder> describeObjectRequest) {
        return this.describeObject((DescribeObjectRequest)((Object)((DescribeObjectRequest.Builder)DescribeObjectRequest.builder().applyMutation(describeObjectRequest)).build()));
    }

    default public <ReturnT> CompletableFuture<ReturnT> getObject(GetObjectRequest getObjectRequest, AsyncResponseTransformer<GetObjectResponse, ReturnT> asyncResponseTransformer) {
        throw new UnsupportedOperationException();
    }

    default public <ReturnT> CompletableFuture<ReturnT> getObject(Consumer<GetObjectRequest.Builder> getObjectRequest, AsyncResponseTransformer<GetObjectResponse, ReturnT> asyncResponseTransformer) {
        return this.getObject((GetObjectRequest)((Object)((GetObjectRequest.Builder)GetObjectRequest.builder().applyMutation(getObjectRequest)).build()), asyncResponseTransformer);
    }

    default public CompletableFuture<GetObjectResponse> getObject(GetObjectRequest getObjectRequest, Path destinationPath) {
        return this.getObject(getObjectRequest, AsyncResponseTransformer.toFile((Path)destinationPath));
    }

    default public CompletableFuture<GetObjectResponse> getObject(Consumer<GetObjectRequest.Builder> getObjectRequest, Path destinationPath) {
        return this.getObject((GetObjectRequest)((Object)((GetObjectRequest.Builder)GetObjectRequest.builder().applyMutation(getObjectRequest)).build()), destinationPath);
    }

    default public CompletableFuture<ListItemsResponse> listItems(ListItemsRequest listItemsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListItemsResponse> listItems(Consumer<ListItemsRequest.Builder> listItemsRequest) {
        return this.listItems((ListItemsRequest)((Object)((ListItemsRequest.Builder)ListItemsRequest.builder().applyMutation(listItemsRequest)).build()));
    }

    default public ListItemsPublisher listItemsPaginator(ListItemsRequest listItemsRequest) {
        throw new UnsupportedOperationException();
    }

    default public ListItemsPublisher listItemsPaginator(Consumer<ListItemsRequest.Builder> listItemsRequest) {
        return this.listItemsPaginator((ListItemsRequest)((Object)((ListItemsRequest.Builder)ListItemsRequest.builder().applyMutation(listItemsRequest)).build()));
    }

    default public CompletableFuture<PutObjectResponse> putObject(PutObjectRequest putObjectRequest, AsyncRequestBody requestBody) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<PutObjectResponse> putObject(Consumer<PutObjectRequest.Builder> putObjectRequest, AsyncRequestBody requestBody) {
        return this.putObject((PutObjectRequest)((Object)((PutObjectRequest.Builder)PutObjectRequest.builder().applyMutation(putObjectRequest)).build()), requestBody);
    }

    default public CompletableFuture<PutObjectResponse> putObject(PutObjectRequest putObjectRequest, Path sourcePath) {
        return this.putObject(putObjectRequest, AsyncRequestBody.fromFile((Path)sourcePath));
    }

    default public CompletableFuture<PutObjectResponse> putObject(Consumer<PutObjectRequest.Builder> putObjectRequest, Path sourcePath) {
        return this.putObject((PutObjectRequest)((Object)((PutObjectRequest.Builder)PutObjectRequest.builder().applyMutation(putObjectRequest)).build()), sourcePath);
    }
}

