/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MultiplexSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MultiplexSettings> {
    private static final SdkField<Integer> MAXIMUM_VIDEO_BUFFER_DELAY_MILLISECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumVideoBufferDelayMilliseconds").getter(MultiplexSettings.getter(MultiplexSettings::maximumVideoBufferDelayMilliseconds)).setter(MultiplexSettings.setter(Builder::maximumVideoBufferDelayMilliseconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumVideoBufferDelayMilliseconds").build()}).build();
    private static final SdkField<Integer> TRANSPORT_STREAM_BITRATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TransportStreamBitrate").getter(MultiplexSettings.getter(MultiplexSettings::transportStreamBitrate)).setter(MultiplexSettings.setter(Builder::transportStreamBitrate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transportStreamBitrate").build()}).build();
    private static final SdkField<Integer> TRANSPORT_STREAM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TransportStreamId").getter(MultiplexSettings.getter(MultiplexSettings::transportStreamId)).setter(MultiplexSettings.setter(Builder::transportStreamId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transportStreamId").build()}).build();
    private static final SdkField<Integer> TRANSPORT_STREAM_RESERVED_BITRATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TransportStreamReservedBitrate").getter(MultiplexSettings.getter(MultiplexSettings::transportStreamReservedBitrate)).setter(MultiplexSettings.setter(Builder::transportStreamReservedBitrate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transportStreamReservedBitrate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAXIMUM_VIDEO_BUFFER_DELAY_MILLISECONDS_FIELD, TRANSPORT_STREAM_BITRATE_FIELD, TRANSPORT_STREAM_ID_FIELD, TRANSPORT_STREAM_RESERVED_BITRATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer maximumVideoBufferDelayMilliseconds;
    private final Integer transportStreamBitrate;
    private final Integer transportStreamId;
    private final Integer transportStreamReservedBitrate;

    private MultiplexSettings(BuilderImpl builder) {
        this.maximumVideoBufferDelayMilliseconds = builder.maximumVideoBufferDelayMilliseconds;
        this.transportStreamBitrate = builder.transportStreamBitrate;
        this.transportStreamId = builder.transportStreamId;
        this.transportStreamReservedBitrate = builder.transportStreamReservedBitrate;
    }

    public final Integer maximumVideoBufferDelayMilliseconds() {
        return this.maximumVideoBufferDelayMilliseconds;
    }

    public final Integer transportStreamBitrate() {
        return this.transportStreamBitrate;
    }

    public final Integer transportStreamId() {
        return this.transportStreamId;
    }

    public final Integer transportStreamReservedBitrate() {
        return this.transportStreamReservedBitrate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumVideoBufferDelayMilliseconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.transportStreamBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.transportStreamId());
        hashCode = 31 * hashCode + Objects.hashCode(this.transportStreamReservedBitrate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultiplexSettings)) {
            return false;
        }
        MultiplexSettings other = (MultiplexSettings)obj;
        return Objects.equals(this.maximumVideoBufferDelayMilliseconds(), other.maximumVideoBufferDelayMilliseconds()) && Objects.equals(this.transportStreamBitrate(), other.transportStreamBitrate()) && Objects.equals(this.transportStreamId(), other.transportStreamId()) && Objects.equals(this.transportStreamReservedBitrate(), other.transportStreamReservedBitrate());
    }

    public final String toString() {
        return ToString.builder((String)"MultiplexSettings").add("MaximumVideoBufferDelayMilliseconds", (Object)this.maximumVideoBufferDelayMilliseconds()).add("TransportStreamBitrate", (Object)this.transportStreamBitrate()).add("TransportStreamId", (Object)this.transportStreamId()).add("TransportStreamReservedBitrate", (Object)this.transportStreamReservedBitrate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaximumVideoBufferDelayMilliseconds": {
                return Optional.ofNullable(clazz.cast(this.maximumVideoBufferDelayMilliseconds()));
            }
            case "TransportStreamBitrate": {
                return Optional.ofNullable(clazz.cast(this.transportStreamBitrate()));
            }
            case "TransportStreamId": {
                return Optional.ofNullable(clazz.cast(this.transportStreamId()));
            }
            case "TransportStreamReservedBitrate": {
                return Optional.ofNullable(clazz.cast(this.transportStreamReservedBitrate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MultiplexSettings, T> g) {
        return obj -> g.apply((MultiplexSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer maximumVideoBufferDelayMilliseconds;
        private Integer transportStreamBitrate;
        private Integer transportStreamId;
        private Integer transportStreamReservedBitrate;

        private BuilderImpl() {
        }

        private BuilderImpl(MultiplexSettings model) {
            this.maximumVideoBufferDelayMilliseconds(model.maximumVideoBufferDelayMilliseconds);
            this.transportStreamBitrate(model.transportStreamBitrate);
            this.transportStreamId(model.transportStreamId);
            this.transportStreamReservedBitrate(model.transportStreamReservedBitrate);
        }

        public final Integer getMaximumVideoBufferDelayMilliseconds() {
            return this.maximumVideoBufferDelayMilliseconds;
        }

        @Override
        public final Builder maximumVideoBufferDelayMilliseconds(Integer maximumVideoBufferDelayMilliseconds) {
            this.maximumVideoBufferDelayMilliseconds = maximumVideoBufferDelayMilliseconds;
            return this;
        }

        public final void setMaximumVideoBufferDelayMilliseconds(Integer maximumVideoBufferDelayMilliseconds) {
            this.maximumVideoBufferDelayMilliseconds = maximumVideoBufferDelayMilliseconds;
        }

        public final Integer getTransportStreamBitrate() {
            return this.transportStreamBitrate;
        }

        @Override
        public final Builder transportStreamBitrate(Integer transportStreamBitrate) {
            this.transportStreamBitrate = transportStreamBitrate;
            return this;
        }

        public final void setTransportStreamBitrate(Integer transportStreamBitrate) {
            this.transportStreamBitrate = transportStreamBitrate;
        }

        public final Integer getTransportStreamId() {
            return this.transportStreamId;
        }

        @Override
        public final Builder transportStreamId(Integer transportStreamId) {
            this.transportStreamId = transportStreamId;
            return this;
        }

        public final void setTransportStreamId(Integer transportStreamId) {
            this.transportStreamId = transportStreamId;
        }

        public final Integer getTransportStreamReservedBitrate() {
            return this.transportStreamReservedBitrate;
        }

        @Override
        public final Builder transportStreamReservedBitrate(Integer transportStreamReservedBitrate) {
            this.transportStreamReservedBitrate = transportStreamReservedBitrate;
            return this;
        }

        public final void setTransportStreamReservedBitrate(Integer transportStreamReservedBitrate) {
            this.transportStreamReservedBitrate = transportStreamReservedBitrate;
        }

        public MultiplexSettings build() {
            return new MultiplexSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MultiplexSettings> {
        public Builder maximumVideoBufferDelayMilliseconds(Integer var1);

        public Builder transportStreamBitrate(Integer var1);

        public Builder transportStreamId(Integer var1);

        public Builder transportStreamReservedBitrate(Integer var1);
    }
}

