/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.Mp2CodingMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Mp2Settings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Mp2Settings> {
    private static final SdkField<Double> BITRATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Bitrate").getter(Mp2Settings.getter(Mp2Settings::bitrate)).setter(Mp2Settings.setter(Builder::bitrate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitrate").build()}).build();
    private static final SdkField<String> CODING_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CodingMode").getter(Mp2Settings.getter(Mp2Settings::codingModeAsString)).setter(Mp2Settings.setter(Builder::codingMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codingMode").build()}).build();
    private static final SdkField<Double> SAMPLE_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("SampleRate").getter(Mp2Settings.getter(Mp2Settings::sampleRate)).setter(Mp2Settings.setter(Builder::sampleRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleRate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BITRATE_FIELD, CODING_MODE_FIELD, SAMPLE_RATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Double bitrate;
    private final String codingMode;
    private final Double sampleRate;

    private Mp2Settings(BuilderImpl builder) {
        this.bitrate = builder.bitrate;
        this.codingMode = builder.codingMode;
        this.sampleRate = builder.sampleRate;
    }

    public final Double bitrate() {
        return this.bitrate;
    }

    public final Mp2CodingMode codingMode() {
        return Mp2CodingMode.fromValue(this.codingMode);
    }

    public final String codingModeAsString() {
        return this.codingMode;
    }

    public final Double sampleRate() {
        return this.sampleRate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.codingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleRate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Mp2Settings)) {
            return false;
        }
        Mp2Settings other = (Mp2Settings)obj;
        return Objects.equals(this.bitrate(), other.bitrate()) && Objects.equals(this.codingModeAsString(), other.codingModeAsString()) && Objects.equals(this.sampleRate(), other.sampleRate());
    }

    public final String toString() {
        return ToString.builder((String)"Mp2Settings").add("Bitrate", (Object)this.bitrate()).add("CodingMode", (Object)this.codingModeAsString()).add("SampleRate", (Object)this.sampleRate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bitrate": {
                return Optional.ofNullable(clazz.cast(this.bitrate()));
            }
            case "CodingMode": {
                return Optional.ofNullable(clazz.cast(this.codingModeAsString()));
            }
            case "SampleRate": {
                return Optional.ofNullable(clazz.cast(this.sampleRate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Mp2Settings, T> g) {
        return obj -> g.apply((Mp2Settings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double bitrate;
        private String codingMode;
        private Double sampleRate;

        private BuilderImpl() {
        }

        private BuilderImpl(Mp2Settings model) {
            this.bitrate(model.bitrate);
            this.codingMode(model.codingMode);
            this.sampleRate(model.sampleRate);
        }

        public final Double getBitrate() {
            return this.bitrate;
        }

        @Override
        public final Builder bitrate(Double bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        public final void setBitrate(Double bitrate) {
            this.bitrate = bitrate;
        }

        public final String getCodingMode() {
            return this.codingMode;
        }

        @Override
        public final Builder codingMode(String codingMode) {
            this.codingMode = codingMode;
            return this;
        }

        @Override
        public final Builder codingMode(Mp2CodingMode codingMode) {
            this.codingMode(codingMode == null ? null : codingMode.toString());
            return this;
        }

        public final void setCodingMode(String codingMode) {
            this.codingMode = codingMode;
        }

        public final Double getSampleRate() {
            return this.sampleRate;
        }

        @Override
        public final Builder sampleRate(Double sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public final void setSampleRate(Double sampleRate) {
            this.sampleRate = sampleRate;
        }

        public Mp2Settings build() {
            return new Mp2Settings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Mp2Settings> {
        public Builder bitrate(Double var1);

        public Builder codingMode(String var1);

        public Builder codingMode(Mp2CodingMode var1);

        public Builder sampleRate(Double var1);
    }
}

