/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AacSpec {
    MPEG2("MPEG2"),
    MPEG4("MPEG4"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AacSpec(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AacSpec fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AacSpec.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AacSpec> knownValues() {
        return Stream.of(AacSpec.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

