/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconvert.model.AudioDescription;
import software.amazon.awssdk.services.mediaconvert.model.CaptionDescriptionPreset;
import software.amazon.awssdk.services.mediaconvert.model.ContainerSettings;
import software.amazon.awssdk.services.mediaconvert.model.VideoDescription;
import software.amazon.awssdk.services.mediaconvert.model.___listOfAudioDescriptionCopier;
import software.amazon.awssdk.services.mediaconvert.model.___listOfCaptionDescriptionPresetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PresetSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PresetSettings> {
    private static final SdkField<List<AudioDescription>> AUDIO_DESCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AudioDescriptions").getter(PresetSettings.getter(PresetSettings::audioDescriptions)).setter(PresetSettings.setter(Builder::audioDescriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioDescriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AudioDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CaptionDescriptionPreset>> CAPTION_DESCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CaptionDescriptions").getter(PresetSettings.getter(PresetSettings::captionDescriptions)).setter(PresetSettings.setter(Builder::captionDescriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captionDescriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CaptionDescriptionPreset::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ContainerSettings> CONTAINER_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ContainerSettings").getter(PresetSettings.getter(PresetSettings::containerSettings)).setter(PresetSettings.setter(Builder::containerSettings)).constructor(ContainerSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerSettings").build()}).build();
    private static final SdkField<VideoDescription> VIDEO_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VideoDescription").getter(PresetSettings.getter(PresetSettings::videoDescription)).setter(PresetSettings.setter(Builder::videoDescription)).constructor(VideoDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoDescription").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_DESCRIPTIONS_FIELD, CAPTION_DESCRIPTIONS_FIELD, CONTAINER_SETTINGS_FIELD, VIDEO_DESCRIPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<AudioDescription> audioDescriptions;
    private final List<CaptionDescriptionPreset> captionDescriptions;
    private final ContainerSettings containerSettings;
    private final VideoDescription videoDescription;

    private PresetSettings(BuilderImpl builder) {
        this.audioDescriptions = builder.audioDescriptions;
        this.captionDescriptions = builder.captionDescriptions;
        this.containerSettings = builder.containerSettings;
        this.videoDescription = builder.videoDescription;
    }

    public final boolean hasAudioDescriptions() {
        return this.audioDescriptions != null && !(this.audioDescriptions instanceof SdkAutoConstructList);
    }

    public final List<AudioDescription> audioDescriptions() {
        return this.audioDescriptions;
    }

    public final boolean hasCaptionDescriptions() {
        return this.captionDescriptions != null && !(this.captionDescriptions instanceof SdkAutoConstructList);
    }

    public final List<CaptionDescriptionPreset> captionDescriptions() {
        return this.captionDescriptions;
    }

    public final ContainerSettings containerSettings() {
        return this.containerSettings;
    }

    public final VideoDescription videoDescription() {
        return this.videoDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAudioDescriptions() ? this.audioDescriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCaptionDescriptions() ? this.captionDescriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.containerSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoDescription());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PresetSettings)) {
            return false;
        }
        PresetSettings other = (PresetSettings)obj;
        return this.hasAudioDescriptions() == other.hasAudioDescriptions() && Objects.equals(this.audioDescriptions(), other.audioDescriptions()) && this.hasCaptionDescriptions() == other.hasCaptionDescriptions() && Objects.equals(this.captionDescriptions(), other.captionDescriptions()) && Objects.equals(this.containerSettings(), other.containerSettings()) && Objects.equals(this.videoDescription(), other.videoDescription());
    }

    public final String toString() {
        return ToString.builder((String)"PresetSettings").add("AudioDescriptions", this.hasAudioDescriptions() ? this.audioDescriptions() : null).add("CaptionDescriptions", this.hasCaptionDescriptions() ? this.captionDescriptions() : null).add("ContainerSettings", (Object)this.containerSettings()).add("VideoDescription", (Object)this.videoDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AudioDescriptions": {
                return Optional.ofNullable(clazz.cast(this.audioDescriptions()));
            }
            case "CaptionDescriptions": {
                return Optional.ofNullable(clazz.cast(this.captionDescriptions()));
            }
            case "ContainerSettings": {
                return Optional.ofNullable(clazz.cast(this.containerSettings()));
            }
            case "VideoDescription": {
                return Optional.ofNullable(clazz.cast(this.videoDescription()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PresetSettings, T> g) {
        return obj -> g.apply((PresetSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AudioDescription> audioDescriptions = DefaultSdkAutoConstructList.getInstance();
        private List<CaptionDescriptionPreset> captionDescriptions = DefaultSdkAutoConstructList.getInstance();
        private ContainerSettings containerSettings;
        private VideoDescription videoDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(PresetSettings model) {
            this.audioDescriptions(model.audioDescriptions);
            this.captionDescriptions(model.captionDescriptions);
            this.containerSettings(model.containerSettings);
            this.videoDescription(model.videoDescription);
        }

        public final List<AudioDescription.Builder> getAudioDescriptions() {
            List<AudioDescription.Builder> result = ___listOfAudioDescriptionCopier.copyToBuilder(this.audioDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder audioDescriptions(Collection<AudioDescription> audioDescriptions) {
            this.audioDescriptions = ___listOfAudioDescriptionCopier.copy(audioDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioDescriptions(AudioDescription ... audioDescriptions) {
            this.audioDescriptions(Arrays.asList(audioDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioDescriptions(Consumer<AudioDescription.Builder> ... audioDescriptions) {
            this.audioDescriptions(Stream.of(audioDescriptions).map(c -> (AudioDescription)((AudioDescription.Builder)AudioDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAudioDescriptions(Collection<AudioDescription.BuilderImpl> audioDescriptions) {
            this.audioDescriptions = ___listOfAudioDescriptionCopier.copyFromBuilder(audioDescriptions);
        }

        public final List<CaptionDescriptionPreset.Builder> getCaptionDescriptions() {
            List<CaptionDescriptionPreset.Builder> result = ___listOfCaptionDescriptionPresetCopier.copyToBuilder(this.captionDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder captionDescriptions(Collection<CaptionDescriptionPreset> captionDescriptions) {
            this.captionDescriptions = ___listOfCaptionDescriptionPresetCopier.copy(captionDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder captionDescriptions(CaptionDescriptionPreset ... captionDescriptions) {
            this.captionDescriptions(Arrays.asList(captionDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder captionDescriptions(Consumer<CaptionDescriptionPreset.Builder> ... captionDescriptions) {
            this.captionDescriptions(Stream.of(captionDescriptions).map(c -> (CaptionDescriptionPreset)((CaptionDescriptionPreset.Builder)CaptionDescriptionPreset.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCaptionDescriptions(Collection<CaptionDescriptionPreset.BuilderImpl> captionDescriptions) {
            this.captionDescriptions = ___listOfCaptionDescriptionPresetCopier.copyFromBuilder(captionDescriptions);
        }

        public final ContainerSettings.Builder getContainerSettings() {
            return this.containerSettings != null ? this.containerSettings.toBuilder() : null;
        }

        @Override
        public final Builder containerSettings(ContainerSettings containerSettings) {
            this.containerSettings = containerSettings;
            return this;
        }

        public final void setContainerSettings(ContainerSettings.BuilderImpl containerSettings) {
            this.containerSettings = containerSettings != null ? containerSettings.build() : null;
        }

        public final VideoDescription.Builder getVideoDescription() {
            return this.videoDescription != null ? this.videoDescription.toBuilder() : null;
        }

        @Override
        public final Builder videoDescription(VideoDescription videoDescription) {
            this.videoDescription = videoDescription;
            return this;
        }

        public final void setVideoDescription(VideoDescription.BuilderImpl videoDescription) {
            this.videoDescription = videoDescription != null ? videoDescription.build() : null;
        }

        public PresetSettings build() {
            return new PresetSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PresetSettings> {
        public Builder audioDescriptions(Collection<AudioDescription> var1);

        public Builder audioDescriptions(AudioDescription ... var1);

        public Builder audioDescriptions(Consumer<AudioDescription.Builder> ... var1);

        public Builder captionDescriptions(Collection<CaptionDescriptionPreset> var1);

        public Builder captionDescriptions(CaptionDescriptionPreset ... var1);

        public Builder captionDescriptions(Consumer<CaptionDescriptionPreset.Builder> ... var1);

        public Builder containerSettings(ContainerSettings var1);

        default public Builder containerSettings(Consumer<ContainerSettings.Builder> containerSettings) {
            return this.containerSettings((ContainerSettings)((ContainerSettings.Builder)ContainerSettings.builder().applyMutation(containerSettings)).build());
        }

        public Builder videoDescription(VideoDescription var1);

        default public Builder videoDescription(Consumer<VideoDescription.Builder> videoDescription) {
            return this.videoDescription((VideoDescription)((VideoDescription.Builder)VideoDescription.builder().applyMutation(videoDescription)).build());
        }
    }
}

