/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum MovReference {
    SELF_CONTAINED("SELF_CONTAINED"),
    EXTERNAL("EXTERNAL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private MovReference(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MovReference fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(MovReference.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MovReference> knownValues() {
        return Stream.of(MovReference.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

