/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacemetering.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.marketplacemetering.model.MarketplaceMeteringRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterUsageRequest
extends MarketplaceMeteringRequest
implements ToCopyableBuilder<Builder, RegisterUsageRequest> {
    private static final SdkField<String> PRODUCT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductCode").getter(RegisterUsageRequest.getter(RegisterUsageRequest::productCode)).setter(RegisterUsageRequest.setter(Builder::productCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductCode").build()}).build();
    private static final SdkField<Integer> PUBLIC_KEY_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PublicKeyVersion").getter(RegisterUsageRequest.getter(RegisterUsageRequest::publicKeyVersion)).setter(RegisterUsageRequest.setter(Builder::publicKeyVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicKeyVersion").build()}).build();
    private static final SdkField<String> NONCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Nonce").getter(RegisterUsageRequest.getter(RegisterUsageRequest::nonce)).setter(RegisterUsageRequest.setter(Builder::nonce)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Nonce").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_CODE_FIELD, PUBLIC_KEY_VERSION_FIELD, NONCE_FIELD));
    private final String productCode;
    private final Integer publicKeyVersion;
    private final String nonce;

    private RegisterUsageRequest(BuilderImpl builder) {
        super(builder);
        this.productCode = builder.productCode;
        this.publicKeyVersion = builder.publicKeyVersion;
        this.nonce = builder.nonce;
    }

    public final String productCode() {
        return this.productCode;
    }

    public final Integer publicKeyVersion() {
        return this.publicKeyVersion;
    }

    public final String nonce() {
        return this.nonce;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.productCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicKeyVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.nonce());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterUsageRequest)) {
            return false;
        }
        RegisterUsageRequest other = (RegisterUsageRequest)((Object)obj);
        return Objects.equals(this.productCode(), other.productCode()) && Objects.equals(this.publicKeyVersion(), other.publicKeyVersion()) && Objects.equals(this.nonce(), other.nonce());
    }

    public final String toString() {
        return ToString.builder((String)"RegisterUsageRequest").add("ProductCode", (Object)this.productCode()).add("PublicKeyVersion", (Object)this.publicKeyVersion()).add("Nonce", (Object)this.nonce()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProductCode": {
                return Optional.ofNullable(clazz.cast(this.productCode()));
            }
            case "PublicKeyVersion": {
                return Optional.ofNullable(clazz.cast(this.publicKeyVersion()));
            }
            case "Nonce": {
                return Optional.ofNullable(clazz.cast(this.nonce()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterUsageRequest, T> g) {
        return obj -> g.apply((RegisterUsageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MarketplaceMeteringRequest.BuilderImpl
    implements Builder {
        private String productCode;
        private Integer publicKeyVersion;
        private String nonce;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterUsageRequest model) {
            super(model);
            this.productCode(model.productCode);
            this.publicKeyVersion(model.publicKeyVersion);
            this.nonce(model.nonce);
        }

        public final String getProductCode() {
            return this.productCode;
        }

        @Override
        public final Builder productCode(String productCode) {
            this.productCode = productCode;
            return this;
        }

        public final void setProductCode(String productCode) {
            this.productCode = productCode;
        }

        public final Integer getPublicKeyVersion() {
            return this.publicKeyVersion;
        }

        @Override
        public final Builder publicKeyVersion(Integer publicKeyVersion) {
            this.publicKeyVersion = publicKeyVersion;
            return this;
        }

        public final void setPublicKeyVersion(Integer publicKeyVersion) {
            this.publicKeyVersion = publicKeyVersion;
        }

        public final String getNonce() {
            return this.nonce;
        }

        @Override
        public final Builder nonce(String nonce) {
            this.nonce = nonce;
            return this;
        }

        public final void setNonce(String nonce) {
            this.nonce = nonce;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterUsageRequest build() {
            return new RegisterUsageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MarketplaceMeteringRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterUsageRequest> {
        public Builder productCode(String var1);

        public Builder publicKeyVersion(Integer var1);

        public Builder nonce(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

