/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacecatalog.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum FailureCode {
    CLIENT_ERROR("CLIENT_ERROR"),
    SERVER_FAULT("SERVER_FAULT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private FailureCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FailureCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(FailureCode.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FailureCode> knownValues() {
        return Stream.of(FailureCode.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

