/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.managedblockchain.ManagedBlockchainClient;
import software.amazon.awssdk.services.managedblockchain.model.ListNodesRequest;
import software.amazon.awssdk.services.managedblockchain.model.ListNodesResponse;

public class ListNodesIterable
implements SdkIterable<ListNodesResponse> {
    private final ManagedBlockchainClient client;
    private final ListNodesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListNodesIterable(ManagedBlockchainClient client, ListNodesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListNodesResponseFetcher();
    }

    public Iterator<ListNodesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListNodesResponseFetcher
    implements SyncPageFetcher<ListNodesResponse> {
        private ListNodesResponseFetcher() {
        }

        public boolean hasNextPage(ListNodesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListNodesResponse nextPage(ListNodesResponse previousPage) {
            if (previousPage == null) {
                return ListNodesIterable.this.client.listNodes(ListNodesIterable.this.firstRequest);
            }
            return ListNodesIterable.this.client.listNodes((ListNodesRequest)((Object)ListNodesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

