/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.managedblockchain.model.ManagedBlockchainRequest;
import software.amazon.awssdk.services.managedblockchain.model.MemberConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMemberRequest
extends ManagedBlockchainRequest
implements ToCopyableBuilder<Builder, CreateMemberRequest> {
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(CreateMemberRequest.getter(CreateMemberRequest::clientRequestToken)).setter(CreateMemberRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> INVITATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InvitationId").getter(CreateMemberRequest.getter(CreateMemberRequest::invitationId)).setter(CreateMemberRequest.setter(Builder::invitationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvitationId").build()}).build();
    private static final SdkField<String> NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkId").getter(CreateMemberRequest.getter(CreateMemberRequest::networkId)).setter(CreateMemberRequest.setter(Builder::networkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("networkId").build()}).build();
    private static final SdkField<MemberConfiguration> MEMBER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MemberConfiguration").getter(CreateMemberRequest.getter(CreateMemberRequest::memberConfiguration)).setter(CreateMemberRequest.setter(Builder::memberConfiguration)).constructor(MemberConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_REQUEST_TOKEN_FIELD, INVITATION_ID_FIELD, NETWORK_ID_FIELD, MEMBER_CONFIGURATION_FIELD));
    private final String clientRequestToken;
    private final String invitationId;
    private final String networkId;
    private final MemberConfiguration memberConfiguration;

    private CreateMemberRequest(BuilderImpl builder) {
        super(builder);
        this.clientRequestToken = builder.clientRequestToken;
        this.invitationId = builder.invitationId;
        this.networkId = builder.networkId;
        this.memberConfiguration = builder.memberConfiguration;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final String invitationId() {
        return this.invitationId;
    }

    public final String networkId() {
        return this.networkId;
    }

    public final MemberConfiguration memberConfiguration() {
        return this.memberConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.invitationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.memberConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMemberRequest)) {
            return false;
        }
        CreateMemberRequest other = (CreateMemberRequest)((Object)obj);
        return Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.invitationId(), other.invitationId()) && Objects.equals(this.networkId(), other.networkId()) && Objects.equals(this.memberConfiguration(), other.memberConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"CreateMemberRequest").add("ClientRequestToken", (Object)this.clientRequestToken()).add("InvitationId", (Object)this.invitationId()).add("NetworkId", (Object)this.networkId()).add("MemberConfiguration", (Object)this.memberConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "InvitationId": {
                return Optional.ofNullable(clazz.cast(this.invitationId()));
            }
            case "NetworkId": {
                return Optional.ofNullable(clazz.cast(this.networkId()));
            }
            case "MemberConfiguration": {
                return Optional.ofNullable(clazz.cast(this.memberConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMemberRequest, T> g) {
        return obj -> g.apply((CreateMemberRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ManagedBlockchainRequest.BuilderImpl
    implements Builder {
        private String clientRequestToken;
        private String invitationId;
        private String networkId;
        private MemberConfiguration memberConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMemberRequest model) {
            super(model);
            this.clientRequestToken(model.clientRequestToken);
            this.invitationId(model.invitationId);
            this.networkId(model.networkId);
            this.memberConfiguration(model.memberConfiguration);
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final String getInvitationId() {
            return this.invitationId;
        }

        @Override
        public final Builder invitationId(String invitationId) {
            this.invitationId = invitationId;
            return this;
        }

        public final void setInvitationId(String invitationId) {
            this.invitationId = invitationId;
        }

        public final String getNetworkId() {
            return this.networkId;
        }

        @Override
        public final Builder networkId(String networkId) {
            this.networkId = networkId;
            return this;
        }

        public final void setNetworkId(String networkId) {
            this.networkId = networkId;
        }

        public final MemberConfiguration.Builder getMemberConfiguration() {
            return this.memberConfiguration != null ? this.memberConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder memberConfiguration(MemberConfiguration memberConfiguration) {
            this.memberConfiguration = memberConfiguration;
            return this;
        }

        public final void setMemberConfiguration(MemberConfiguration.BuilderImpl memberConfiguration) {
            this.memberConfiguration = memberConfiguration != null ? memberConfiguration.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMemberRequest build() {
            return new CreateMemberRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ManagedBlockchainRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateMemberRequest> {
        public Builder clientRequestToken(String var1);

        public Builder invitationId(String var1);

        public Builder networkId(String var1);

        public Builder memberConfiguration(MemberConfiguration var1);

        default public Builder memberConfiguration(Consumer<MemberConfiguration.Builder> memberConfiguration) {
            return this.memberConfiguration((MemberConfiguration)((MemberConfiguration.Builder)MemberConfiguration.builder().applyMutation(memberConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

