/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.macie2.Macie2Client;
import software.amazon.awssdk.services.macie2.model.FindingsFilterListItem;
import software.amazon.awssdk.services.macie2.model.ListFindingsFiltersRequest;
import software.amazon.awssdk.services.macie2.model.ListFindingsFiltersResponse;

public class ListFindingsFiltersIterable
implements SdkIterable<ListFindingsFiltersResponse> {
    private final Macie2Client client;
    private final ListFindingsFiltersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFindingsFiltersIterable(Macie2Client client, ListFindingsFiltersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListFindingsFiltersResponseFetcher();
    }

    public Iterator<ListFindingsFiltersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FindingsFilterListItem> findingsFilterListItems() {
        Function<ListFindingsFiltersResponse, Iterator> getIterator = response -> {
            if (response != null && response.findingsFilterListItems() != null) {
                return response.findingsFilterListItems().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListFindingsFiltersResponseFetcher
    implements SyncPageFetcher<ListFindingsFiltersResponse> {
        private ListFindingsFiltersResponseFetcher() {
        }

        public boolean hasNextPage(ListFindingsFiltersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFindingsFiltersResponse nextPage(ListFindingsFiltersResponse previousPage) {
            if (previousPage == null) {
                return ListFindingsFiltersIterable.this.client.listFindingsFilters(ListFindingsFiltersIterable.this.firstRequest);
            }
            return ListFindingsFiltersIterable.this.client.listFindingsFilters((ListFindingsFiltersRequest)((Object)ListFindingsFiltersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

