/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.macie2.model.FindingCriteria;
import software.amazon.awssdk.services.macie2.model.FindingStatisticsSortCriteria;
import software.amazon.awssdk.services.macie2.model.GroupBy;
import software.amazon.awssdk.services.macie2.model.Macie2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetFindingStatisticsRequest
extends Macie2Request
implements ToCopyableBuilder<Builder, GetFindingStatisticsRequest> {
    private static final SdkField<FindingCriteria> FINDING_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("findingCriteria").getter(GetFindingStatisticsRequest.getter(GetFindingStatisticsRequest::findingCriteria)).setter(GetFindingStatisticsRequest.setter(Builder::findingCriteria)).constructor(FindingCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingCriteria").build()}).build();
    private static final SdkField<String> GROUP_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("groupBy").getter(GetFindingStatisticsRequest.getter(GetFindingStatisticsRequest::groupByAsString)).setter(GetFindingStatisticsRequest.setter(Builder::groupBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupBy").build()}).build();
    private static final SdkField<Integer> SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("size").getter(GetFindingStatisticsRequest.getter(GetFindingStatisticsRequest::size)).setter(GetFindingStatisticsRequest.setter(Builder::size)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("size").build()}).build();
    private static final SdkField<FindingStatisticsSortCriteria> SORT_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sortCriteria").getter(GetFindingStatisticsRequest.getter(GetFindingStatisticsRequest::sortCriteria)).setter(GetFindingStatisticsRequest.setter(Builder::sortCriteria)).constructor(FindingStatisticsSortCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortCriteria").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDING_CRITERIA_FIELD, GROUP_BY_FIELD, SIZE_FIELD, SORT_CRITERIA_FIELD));
    private final FindingCriteria findingCriteria;
    private final String groupBy;
    private final Integer size;
    private final FindingStatisticsSortCriteria sortCriteria;

    private GetFindingStatisticsRequest(BuilderImpl builder) {
        super(builder);
        this.findingCriteria = builder.findingCriteria;
        this.groupBy = builder.groupBy;
        this.size = builder.size;
        this.sortCriteria = builder.sortCriteria;
    }

    public final FindingCriteria findingCriteria() {
        return this.findingCriteria;
    }

    public final GroupBy groupBy() {
        return GroupBy.fromValue(this.groupBy);
    }

    public final String groupByAsString() {
        return this.groupBy;
    }

    public final Integer size() {
        return this.size;
    }

    public final FindingStatisticsSortCriteria sortCriteria() {
        return this.sortCriteria;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.findingCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.size());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortCriteria());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFindingStatisticsRequest)) {
            return false;
        }
        GetFindingStatisticsRequest other = (GetFindingStatisticsRequest)((Object)obj);
        return Objects.equals(this.findingCriteria(), other.findingCriteria()) && Objects.equals(this.groupByAsString(), other.groupByAsString()) && Objects.equals(this.size(), other.size()) && Objects.equals(this.sortCriteria(), other.sortCriteria());
    }

    public final String toString() {
        return ToString.builder((String)"GetFindingStatisticsRequest").add("FindingCriteria", (Object)this.findingCriteria()).add("GroupBy", (Object)this.groupByAsString()).add("Size", (Object)this.size()).add("SortCriteria", (Object)this.sortCriteria()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "findingCriteria": {
                return Optional.ofNullable(clazz.cast(this.findingCriteria()));
            }
            case "groupBy": {
                return Optional.ofNullable(clazz.cast(this.groupByAsString()));
            }
            case "size": {
                return Optional.ofNullable(clazz.cast(this.size()));
            }
            case "sortCriteria": {
                return Optional.ofNullable(clazz.cast(this.sortCriteria()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFindingStatisticsRequest, T> g) {
        return obj -> g.apply((GetFindingStatisticsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Macie2Request.BuilderImpl
    implements Builder {
        private FindingCriteria findingCriteria;
        private String groupBy;
        private Integer size;
        private FindingStatisticsSortCriteria sortCriteria;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFindingStatisticsRequest model) {
            super(model);
            this.findingCriteria(model.findingCriteria);
            this.groupBy(model.groupBy);
            this.size(model.size);
            this.sortCriteria(model.sortCriteria);
        }

        public final FindingCriteria.Builder getFindingCriteria() {
            return this.findingCriteria != null ? this.findingCriteria.toBuilder() : null;
        }

        @Override
        public final Builder findingCriteria(FindingCriteria findingCriteria) {
            this.findingCriteria = findingCriteria;
            return this;
        }

        public final void setFindingCriteria(FindingCriteria.BuilderImpl findingCriteria) {
            this.findingCriteria = findingCriteria != null ? findingCriteria.build() : null;
        }

        public final String getGroupBy() {
            return this.groupBy;
        }

        @Override
        public final Builder groupBy(String groupBy) {
            this.groupBy = groupBy;
            return this;
        }

        @Override
        public final Builder groupBy(GroupBy groupBy) {
            this.groupBy(groupBy == null ? null : groupBy.toString());
            return this;
        }

        public final void setGroupBy(String groupBy) {
            this.groupBy = groupBy;
        }

        public final Integer getSize() {
            return this.size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        public final FindingStatisticsSortCriteria.Builder getSortCriteria() {
            return this.sortCriteria != null ? this.sortCriteria.toBuilder() : null;
        }

        @Override
        public final Builder sortCriteria(FindingStatisticsSortCriteria sortCriteria) {
            this.sortCriteria = sortCriteria;
            return this;
        }

        public final void setSortCriteria(FindingStatisticsSortCriteria.BuilderImpl sortCriteria) {
            this.sortCriteria = sortCriteria != null ? sortCriteria.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetFindingStatisticsRequest build() {
            return new GetFindingStatisticsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Macie2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetFindingStatisticsRequest> {
        public Builder findingCriteria(FindingCriteria var1);

        default public Builder findingCriteria(Consumer<FindingCriteria.Builder> findingCriteria) {
            return this.findingCriteria((FindingCriteria)((FindingCriteria.Builder)FindingCriteria.builder().applyMutation(findingCriteria)).build());
        }

        public Builder groupBy(String var1);

        public Builder groupBy(GroupBy var1);

        public Builder size(Integer var1);

        public Builder sortCriteria(FindingStatisticsSortCriteria var1);

        default public Builder sortCriteria(Consumer<FindingStatisticsSortCriteria.Builder> sortCriteria) {
            return this.sortCriteria((FindingStatisticsSortCriteria)((FindingStatisticsSortCriteria.Builder)FindingStatisticsSortCriteria.builder().applyMutation(sortCriteria)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

