/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.macie.model.MacieRequest;
import software.amazon.awssdk.services.macie.model.S3ResourceClassificationUpdate;
import software.amazon.awssdk.services.macie.model.S3ResourcesClassificationUpdateCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateS3ResourcesRequest
extends MacieRequest
implements ToCopyableBuilder<Builder, UpdateS3ResourcesRequest> {
    private static final SdkField<String> MEMBER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("memberAccountId").getter(UpdateS3ResourcesRequest.getter(UpdateS3ResourcesRequest::memberAccountId)).setter(UpdateS3ResourcesRequest.setter(Builder::memberAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memberAccountId").build()}).build();
    private static final SdkField<List<S3ResourceClassificationUpdate>> S3_RESOURCES_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("s3ResourcesUpdate").getter(UpdateS3ResourcesRequest.getter(UpdateS3ResourcesRequest::s3ResourcesUpdate)).setter(UpdateS3ResourcesRequest.setter(Builder::s3ResourcesUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3ResourcesUpdate").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(S3ResourceClassificationUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBER_ACCOUNT_ID_FIELD, S3_RESOURCES_UPDATE_FIELD));
    private final String memberAccountId;
    private final List<S3ResourceClassificationUpdate> s3ResourcesUpdate;

    private UpdateS3ResourcesRequest(BuilderImpl builder) {
        super(builder);
        this.memberAccountId = builder.memberAccountId;
        this.s3ResourcesUpdate = builder.s3ResourcesUpdate;
    }

    public final String memberAccountId() {
        return this.memberAccountId;
    }

    public final boolean hasS3ResourcesUpdate() {
        return this.s3ResourcesUpdate != null && !(this.s3ResourcesUpdate instanceof SdkAutoConstructList);
    }

    public final List<S3ResourceClassificationUpdate> s3ResourcesUpdate() {
        return this.s3ResourcesUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.memberAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasS3ResourcesUpdate() ? this.s3ResourcesUpdate() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateS3ResourcesRequest)) {
            return false;
        }
        UpdateS3ResourcesRequest other = (UpdateS3ResourcesRequest)((Object)obj);
        return Objects.equals(this.memberAccountId(), other.memberAccountId()) && this.hasS3ResourcesUpdate() == other.hasS3ResourcesUpdate() && Objects.equals(this.s3ResourcesUpdate(), other.s3ResourcesUpdate());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateS3ResourcesRequest").add("MemberAccountId", (Object)this.memberAccountId()).add("S3ResourcesUpdate", this.hasS3ResourcesUpdate() ? this.s3ResourcesUpdate() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "memberAccountId": {
                return Optional.ofNullable(clazz.cast(this.memberAccountId()));
            }
            case "s3ResourcesUpdate": {
                return Optional.ofNullable(clazz.cast(this.s3ResourcesUpdate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateS3ResourcesRequest, T> g) {
        return obj -> g.apply((UpdateS3ResourcesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MacieRequest.BuilderImpl
    implements Builder {
        private String memberAccountId;
        private List<S3ResourceClassificationUpdate> s3ResourcesUpdate = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateS3ResourcesRequest model) {
            super(model);
            this.memberAccountId(model.memberAccountId);
            this.s3ResourcesUpdate(model.s3ResourcesUpdate);
        }

        public final String getMemberAccountId() {
            return this.memberAccountId;
        }

        @Override
        public final Builder memberAccountId(String memberAccountId) {
            this.memberAccountId = memberAccountId;
            return this;
        }

        public final void setMemberAccountId(String memberAccountId) {
            this.memberAccountId = memberAccountId;
        }

        public final List<S3ResourceClassificationUpdate.Builder> getS3ResourcesUpdate() {
            List<S3ResourceClassificationUpdate.Builder> result = S3ResourcesClassificationUpdateCopier.copyToBuilder(this.s3ResourcesUpdate);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder s3ResourcesUpdate(Collection<S3ResourceClassificationUpdate> s3ResourcesUpdate) {
            this.s3ResourcesUpdate = S3ResourcesClassificationUpdateCopier.copy(s3ResourcesUpdate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3ResourcesUpdate(S3ResourceClassificationUpdate ... s3ResourcesUpdate) {
            this.s3ResourcesUpdate(Arrays.asList(s3ResourcesUpdate));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3ResourcesUpdate(Consumer<S3ResourceClassificationUpdate.Builder> ... s3ResourcesUpdate) {
            this.s3ResourcesUpdate(Stream.of(s3ResourcesUpdate).map(c -> (S3ResourceClassificationUpdate)((S3ResourceClassificationUpdate.Builder)S3ResourceClassificationUpdate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setS3ResourcesUpdate(Collection<S3ResourceClassificationUpdate.BuilderImpl> s3ResourcesUpdate) {
            this.s3ResourcesUpdate = S3ResourcesClassificationUpdateCopier.copyFromBuilder(s3ResourcesUpdate);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateS3ResourcesRequest build() {
            return new UpdateS3ResourcesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MacieRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateS3ResourcesRequest> {
        public Builder memberAccountId(String var1);

        public Builder s3ResourcesUpdate(Collection<S3ResourceClassificationUpdate> var1);

        public Builder s3ResourcesUpdate(S3ResourceClassificationUpdate ... var1);

        public Builder s3ResourcesUpdate(Consumer<S3ResourceClassificationUpdate.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

