/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.macie.model.ClassificationTypeUpdate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3ResourceClassificationUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3ResourceClassificationUpdate> {
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bucketName").getter(S3ResourceClassificationUpdate.getter(S3ResourceClassificationUpdate::bucketName)).setter(S3ResourceClassificationUpdate.setter(Builder::bucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketName").build()}).build();
    private static final SdkField<String> PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("prefix").getter(S3ResourceClassificationUpdate.getter(S3ResourceClassificationUpdate::prefix)).setter(S3ResourceClassificationUpdate.setter(Builder::prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prefix").build()}).build();
    private static final SdkField<ClassificationTypeUpdate> CLASSIFICATION_TYPE_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("classificationTypeUpdate").getter(S3ResourceClassificationUpdate.getter(S3ResourceClassificationUpdate::classificationTypeUpdate)).setter(S3ResourceClassificationUpdate.setter(Builder::classificationTypeUpdate)).constructor(ClassificationTypeUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("classificationTypeUpdate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_NAME_FIELD, PREFIX_FIELD, CLASSIFICATION_TYPE_UPDATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String bucketName;
    private final String prefix;
    private final ClassificationTypeUpdate classificationTypeUpdate;

    private S3ResourceClassificationUpdate(BuilderImpl builder) {
        this.bucketName = builder.bucketName;
        this.prefix = builder.prefix;
        this.classificationTypeUpdate = builder.classificationTypeUpdate;
    }

    public final String bucketName() {
        return this.bucketName;
    }

    public final String prefix() {
        return this.prefix;
    }

    public final ClassificationTypeUpdate classificationTypeUpdate() {
        return this.classificationTypeUpdate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.classificationTypeUpdate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ResourceClassificationUpdate)) {
            return false;
        }
        S3ResourceClassificationUpdate other = (S3ResourceClassificationUpdate)obj;
        return Objects.equals(this.bucketName(), other.bucketName()) && Objects.equals(this.prefix(), other.prefix()) && Objects.equals(this.classificationTypeUpdate(), other.classificationTypeUpdate());
    }

    public final String toString() {
        return ToString.builder((String)"S3ResourceClassificationUpdate").add("BucketName", (Object)this.bucketName()).add("Prefix", (Object)this.prefix()).add("ClassificationTypeUpdate", (Object)this.classificationTypeUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bucketName": {
                return Optional.ofNullable(clazz.cast(this.bucketName()));
            }
            case "prefix": {
                return Optional.ofNullable(clazz.cast(this.prefix()));
            }
            case "classificationTypeUpdate": {
                return Optional.ofNullable(clazz.cast(this.classificationTypeUpdate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3ResourceClassificationUpdate, T> g) {
        return obj -> g.apply((S3ResourceClassificationUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucketName;
        private String prefix;
        private ClassificationTypeUpdate classificationTypeUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ResourceClassificationUpdate model) {
            this.bucketName(model.bucketName);
            this.prefix(model.prefix);
            this.classificationTypeUpdate(model.classificationTypeUpdate);
        }

        public final String getBucketName() {
            return this.bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final ClassificationTypeUpdate.Builder getClassificationTypeUpdate() {
            return this.classificationTypeUpdate != null ? this.classificationTypeUpdate.toBuilder() : null;
        }

        @Override
        public final Builder classificationTypeUpdate(ClassificationTypeUpdate classificationTypeUpdate) {
            this.classificationTypeUpdate = classificationTypeUpdate;
            return this;
        }

        public final void setClassificationTypeUpdate(ClassificationTypeUpdate.BuilderImpl classificationTypeUpdate) {
            this.classificationTypeUpdate = classificationTypeUpdate != null ? classificationTypeUpdate.build() : null;
        }

        public S3ResourceClassificationUpdate build() {
            return new S3ResourceClassificationUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3ResourceClassificationUpdate> {
        public Builder bucketName(String var1);

        public Builder prefix(String var1);

        public Builder classificationTypeUpdate(ClassificationTypeUpdate var1);

        default public Builder classificationTypeUpdate(Consumer<ClassificationTypeUpdate.Builder> classificationTypeUpdate) {
            return this.classificationTypeUpdate((ClassificationTypeUpdate)((ClassificationTypeUpdate.Builder)ClassificationTypeUpdate.builder().applyMutation(classificationTypeUpdate)).build());
        }
    }
}

