/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.machinelearning.MachineLearningClient;
import software.amazon.awssdk.services.machinelearning.model.BatchPrediction;
import software.amazon.awssdk.services.machinelearning.model.DescribeBatchPredictionsRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeBatchPredictionsResponse;

public class DescribeBatchPredictionsIterable
implements SdkIterable<DescribeBatchPredictionsResponse> {
    private final MachineLearningClient client;
    private final DescribeBatchPredictionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeBatchPredictionsIterable(MachineLearningClient client, DescribeBatchPredictionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeBatchPredictionsResponseFetcher();
    }

    public Iterator<DescribeBatchPredictionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<BatchPrediction> results() {
        Function<DescribeBatchPredictionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.results() != null) {
                return response.results().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeBatchPredictionsResponseFetcher
    implements SyncPageFetcher<DescribeBatchPredictionsResponse> {
        private DescribeBatchPredictionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeBatchPredictionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeBatchPredictionsResponse nextPage(DescribeBatchPredictionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeBatchPredictionsIterable.this.client.describeBatchPredictions(DescribeBatchPredictionsIterable.this.firstRequest);
            }
            return DescribeBatchPredictionsIterable.this.client.describeBatchPredictions((DescribeBatchPredictionsRequest)((Object)DescribeBatchPredictionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

