/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lookoutmetrics.model.LookoutMetricsResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.MetricSetSummary;
import software.amazon.awssdk.services.lookoutmetrics.model.MetricSetSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMetricSetsResponse
extends LookoutMetricsResponse
implements ToCopyableBuilder<Builder, ListMetricSetsResponse> {
    private static final SdkField<List<MetricSetSummary>> METRIC_SET_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricSetSummaryList").getter(ListMetricSetsResponse.getter(ListMetricSetsResponse::metricSetSummaryList)).setter(ListMetricSetsResponse.setter(Builder::metricSetSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricSetSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricSetSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListMetricSetsResponse.getter(ListMetricSetsResponse::nextToken)).setter(ListMetricSetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_SET_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<MetricSetSummary> metricSetSummaryList;
    private final String nextToken;

    private ListMetricSetsResponse(BuilderImpl builder) {
        super(builder);
        this.metricSetSummaryList = builder.metricSetSummaryList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasMetricSetSummaryList() {
        return this.metricSetSummaryList != null && !(this.metricSetSummaryList instanceof SdkAutoConstructList);
    }

    public final List<MetricSetSummary> metricSetSummaryList() {
        return this.metricSetSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricSetSummaryList() ? this.metricSetSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMetricSetsResponse)) {
            return false;
        }
        ListMetricSetsResponse other = (ListMetricSetsResponse)((Object)obj);
        return this.hasMetricSetSummaryList() == other.hasMetricSetSummaryList() && Objects.equals(this.metricSetSummaryList(), other.metricSetSummaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListMetricSetsResponse").add("MetricSetSummaryList", this.hasMetricSetSummaryList() ? this.metricSetSummaryList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MetricSetSummaryList": {
                return Optional.ofNullable(clazz.cast(this.metricSetSummaryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMetricSetsResponse, T> g) {
        return obj -> g.apply((ListMetricSetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutMetricsResponse.BuilderImpl
    implements Builder {
        private List<MetricSetSummary> metricSetSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMetricSetsResponse model) {
            super(model);
            this.metricSetSummaryList(model.metricSetSummaryList);
            this.nextToken(model.nextToken);
        }

        public final List<MetricSetSummary.Builder> getMetricSetSummaryList() {
            List<MetricSetSummary.Builder> result = MetricSetSummaryListCopier.copyToBuilder(this.metricSetSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder metricSetSummaryList(Collection<MetricSetSummary> metricSetSummaryList) {
            this.metricSetSummaryList = MetricSetSummaryListCopier.copy(metricSetSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricSetSummaryList(MetricSetSummary ... metricSetSummaryList) {
            this.metricSetSummaryList(Arrays.asList(metricSetSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricSetSummaryList(Consumer<MetricSetSummary.Builder> ... metricSetSummaryList) {
            this.metricSetSummaryList(Stream.of(metricSetSummaryList).map(c -> (MetricSetSummary)((MetricSetSummary.Builder)MetricSetSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMetricSetSummaryList(Collection<MetricSetSummary.BuilderImpl> metricSetSummaryList) {
            this.metricSetSummaryList = MetricSetSummaryListCopier.copyFromBuilder(metricSetSummaryList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListMetricSetsResponse build() {
            return new ListMetricSetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LookoutMetricsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMetricSetsResponse> {
        public Builder metricSetSummaryList(Collection<MetricSetSummary> var1);

        public Builder metricSetSummaryList(MetricSetSummary ... var1);

        public Builder metricSetSummaryList(Consumer<MetricSetSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

