/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lookoutmetrics.model.MetricLevelImpact;
import software.amazon.awssdk.services.lookoutmetrics.model.MetricLevelImpactListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnomalyGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnomalyGroup> {
    private static final SdkField<String> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartTime").getter(AnomalyGroup.getter(AnomalyGroup::startTime)).setter(AnomalyGroup.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<String> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndTime").getter(AnomalyGroup.getter(AnomalyGroup::endTime)).setter(AnomalyGroup.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<String> ANOMALY_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnomalyGroupId").getter(AnomalyGroup.getter(AnomalyGroup::anomalyGroupId)).setter(AnomalyGroup.setter(Builder::anomalyGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyGroupId").build()}).build();
    private static final SdkField<Double> ANOMALY_GROUP_SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("AnomalyGroupScore").getter(AnomalyGroup.getter(AnomalyGroup::anomalyGroupScore)).setter(AnomalyGroup.setter(Builder::anomalyGroupScore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyGroupScore").build()}).build();
    private static final SdkField<String> PRIMARY_METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrimaryMetricName").getter(AnomalyGroup.getter(AnomalyGroup::primaryMetricName)).setter(AnomalyGroup.setter(Builder::primaryMetricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryMetricName").build()}).build();
    private static final SdkField<List<MetricLevelImpact>> METRIC_LEVEL_IMPACT_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricLevelImpactList").getter(AnomalyGroup.getter(AnomalyGroup::metricLevelImpactList)).setter(AnomalyGroup.setter(Builder::metricLevelImpactList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricLevelImpactList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricLevelImpact::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD, END_TIME_FIELD, ANOMALY_GROUP_ID_FIELD, ANOMALY_GROUP_SCORE_FIELD, PRIMARY_METRIC_NAME_FIELD, METRIC_LEVEL_IMPACT_LIST_FIELD));
    private static final long serialVersionUID = 1L;
    private final String startTime;
    private final String endTime;
    private final String anomalyGroupId;
    private final Double anomalyGroupScore;
    private final String primaryMetricName;
    private final List<MetricLevelImpact> metricLevelImpactList;

    private AnomalyGroup(BuilderImpl builder) {
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.anomalyGroupId = builder.anomalyGroupId;
        this.anomalyGroupScore = builder.anomalyGroupScore;
        this.primaryMetricName = builder.primaryMetricName;
        this.metricLevelImpactList = builder.metricLevelImpactList;
    }

    public final String startTime() {
        return this.startTime;
    }

    public final String endTime() {
        return this.endTime;
    }

    public final String anomalyGroupId() {
        return this.anomalyGroupId;
    }

    public final Double anomalyGroupScore() {
        return this.anomalyGroupScore;
    }

    public final String primaryMetricName() {
        return this.primaryMetricName;
    }

    public final boolean hasMetricLevelImpactList() {
        return this.metricLevelImpactList != null && !(this.metricLevelImpactList instanceof SdkAutoConstructList);
    }

    public final List<MetricLevelImpact> metricLevelImpactList() {
        return this.metricLevelImpactList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyGroupScore());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryMetricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricLevelImpactList() ? this.metricLevelImpactList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnomalyGroup)) {
            return false;
        }
        AnomalyGroup other = (AnomalyGroup)obj;
        return Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.anomalyGroupId(), other.anomalyGroupId()) && Objects.equals(this.anomalyGroupScore(), other.anomalyGroupScore()) && Objects.equals(this.primaryMetricName(), other.primaryMetricName()) && this.hasMetricLevelImpactList() == other.hasMetricLevelImpactList() && Objects.equals(this.metricLevelImpactList(), other.metricLevelImpactList());
    }

    public final String toString() {
        return ToString.builder((String)"AnomalyGroup").add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("AnomalyGroupId", (Object)this.anomalyGroupId()).add("AnomalyGroupScore", (Object)this.anomalyGroupScore()).add("PrimaryMetricName", (Object)this.primaryMetricName()).add("MetricLevelImpactList", this.hasMetricLevelImpactList() ? this.metricLevelImpactList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "AnomalyGroupId": {
                return Optional.ofNullable(clazz.cast(this.anomalyGroupId()));
            }
            case "AnomalyGroupScore": {
                return Optional.ofNullable(clazz.cast(this.anomalyGroupScore()));
            }
            case "PrimaryMetricName": {
                return Optional.ofNullable(clazz.cast(this.primaryMetricName()));
            }
            case "MetricLevelImpactList": {
                return Optional.ofNullable(clazz.cast(this.metricLevelImpactList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnomalyGroup, T> g) {
        return obj -> g.apply((AnomalyGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String startTime;
        private String endTime;
        private String anomalyGroupId;
        private Double anomalyGroupScore;
        private String primaryMetricName;
        private List<MetricLevelImpact> metricLevelImpactList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AnomalyGroup model) {
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.anomalyGroupId(model.anomalyGroupId);
            this.anomalyGroupScore(model.anomalyGroupScore);
            this.primaryMetricName(model.primaryMetricName);
            this.metricLevelImpactList(model.metricLevelImpactList);
        }

        public final String getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        public final String getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        public final String getAnomalyGroupId() {
            return this.anomalyGroupId;
        }

        @Override
        public final Builder anomalyGroupId(String anomalyGroupId) {
            this.anomalyGroupId = anomalyGroupId;
            return this;
        }

        public final void setAnomalyGroupId(String anomalyGroupId) {
            this.anomalyGroupId = anomalyGroupId;
        }

        public final Double getAnomalyGroupScore() {
            return this.anomalyGroupScore;
        }

        @Override
        public final Builder anomalyGroupScore(Double anomalyGroupScore) {
            this.anomalyGroupScore = anomalyGroupScore;
            return this;
        }

        public final void setAnomalyGroupScore(Double anomalyGroupScore) {
            this.anomalyGroupScore = anomalyGroupScore;
        }

        public final String getPrimaryMetricName() {
            return this.primaryMetricName;
        }

        @Override
        public final Builder primaryMetricName(String primaryMetricName) {
            this.primaryMetricName = primaryMetricName;
            return this;
        }

        public final void setPrimaryMetricName(String primaryMetricName) {
            this.primaryMetricName = primaryMetricName;
        }

        public final List<MetricLevelImpact.Builder> getMetricLevelImpactList() {
            List<MetricLevelImpact.Builder> result = MetricLevelImpactListCopier.copyToBuilder(this.metricLevelImpactList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder metricLevelImpactList(Collection<MetricLevelImpact> metricLevelImpactList) {
            this.metricLevelImpactList = MetricLevelImpactListCopier.copy(metricLevelImpactList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricLevelImpactList(MetricLevelImpact ... metricLevelImpactList) {
            this.metricLevelImpactList(Arrays.asList(metricLevelImpactList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricLevelImpactList(Consumer<MetricLevelImpact.Builder> ... metricLevelImpactList) {
            this.metricLevelImpactList(Stream.of(metricLevelImpactList).map(c -> (MetricLevelImpact)((MetricLevelImpact.Builder)MetricLevelImpact.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMetricLevelImpactList(Collection<MetricLevelImpact.BuilderImpl> metricLevelImpactList) {
            this.metricLevelImpactList = MetricLevelImpactListCopier.copyFromBuilder(metricLevelImpactList);
        }

        public AnomalyGroup build() {
            return new AnomalyGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnomalyGroup> {
        public Builder startTime(String var1);

        public Builder endTime(String var1);

        public Builder anomalyGroupId(String var1);

        public Builder anomalyGroupScore(Double var1);

        public Builder primaryMetricName(String var1);

        public Builder metricLevelImpactList(Collection<MetricLevelImpact> var1);

        public Builder metricLevelImpactList(MetricLevelImpact ... var1);

        public Builder metricLevelImpactList(Consumer<MetricLevelImpact.Builder> ... var1);
    }
}

