/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.OriginProtocolPolicyEnum;
import software.amazon.awssdk.services.lightsail.model.RegionName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InputOrigin
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InputOrigin> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(InputOrigin.getter(InputOrigin::name)).setter(InputOrigin.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> REGION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("regionName").getter(InputOrigin.getter(InputOrigin::regionNameAsString)).setter(InputOrigin.setter(Builder::regionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionName").build()}).build();
    private static final SdkField<String> PROTOCOL_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("protocolPolicy").getter(InputOrigin.getter(InputOrigin::protocolPolicyAsString)).setter(InputOrigin.setter(Builder::protocolPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocolPolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, REGION_NAME_FIELD, PROTOCOL_POLICY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String regionName;
    private final String protocolPolicy;

    private InputOrigin(BuilderImpl builder) {
        this.name = builder.name;
        this.regionName = builder.regionName;
        this.protocolPolicy = builder.protocolPolicy;
    }

    public final String name() {
        return this.name;
    }

    public final RegionName regionName() {
        return RegionName.fromValue(this.regionName);
    }

    public final String regionNameAsString() {
        return this.regionName;
    }

    public final OriginProtocolPolicyEnum protocolPolicy() {
        return OriginProtocolPolicyEnum.fromValue(this.protocolPolicy);
    }

    public final String protocolPolicyAsString() {
        return this.protocolPolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolPolicyAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputOrigin)) {
            return false;
        }
        InputOrigin other = (InputOrigin)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.regionNameAsString(), other.regionNameAsString()) && Objects.equals(this.protocolPolicyAsString(), other.protocolPolicyAsString());
    }

    public final String toString() {
        return ToString.builder((String)"InputOrigin").add("Name", (Object)this.name()).add("RegionName", (Object)this.regionNameAsString()).add("ProtocolPolicy", (Object)this.protocolPolicyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "regionName": {
                return Optional.ofNullable(clazz.cast(this.regionNameAsString()));
            }
            case "protocolPolicy": {
                return Optional.ofNullable(clazz.cast(this.protocolPolicyAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputOrigin, T> g) {
        return obj -> g.apply((InputOrigin)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String regionName;
        private String protocolPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(InputOrigin model) {
            this.name(model.name);
            this.regionName(model.regionName);
            this.protocolPolicy(model.protocolPolicy);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRegionName() {
            return this.regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        @Override
        public final Builder regionName(RegionName regionName) {
            this.regionName(regionName == null ? null : regionName.toString());
            return this;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        public final String getProtocolPolicy() {
            return this.protocolPolicy;
        }

        @Override
        public final Builder protocolPolicy(String protocolPolicy) {
            this.protocolPolicy = protocolPolicy;
            return this;
        }

        @Override
        public final Builder protocolPolicy(OriginProtocolPolicyEnum protocolPolicy) {
            this.protocolPolicy(protocolPolicy == null ? null : protocolPolicy.toString());
            return this;
        }

        public final void setProtocolPolicy(String protocolPolicy) {
            this.protocolPolicy = protocolPolicy;
        }

        public InputOrigin build() {
            return new InputOrigin(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InputOrigin> {
        public Builder name(String var1);

        public Builder regionName(String var1);

        public Builder regionName(RegionName var1);

        public Builder protocolPolicy(String var1);

        public Builder protocolPolicy(OriginProtocolPolicyEnum var1);
    }
}

