/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum HeaderEnum {
    ACCEPT("Accept"),
    ACCEPT_CHARSET("Accept-Charset"),
    ACCEPT_DATETIME("Accept-Datetime"),
    ACCEPT_ENCODING("Accept-Encoding"),
    ACCEPT_LANGUAGE("Accept-Language"),
    AUTHORIZATION("Authorization"),
    CLOUD_FRONT_FORWARDED_PROTO("CloudFront-Forwarded-Proto"),
    CLOUD_FRONT_IS_DESKTOP_VIEWER("CloudFront-Is-Desktop-Viewer"),
    CLOUD_FRONT_IS_MOBILE_VIEWER("CloudFront-Is-Mobile-Viewer"),
    CLOUD_FRONT_IS_SMART_TV_VIEWER("CloudFront-Is-SmartTV-Viewer"),
    CLOUD_FRONT_IS_TABLET_VIEWER("CloudFront-Is-Tablet-Viewer"),
    CLOUD_FRONT_VIEWER_COUNTRY("CloudFront-Viewer-Country"),
    HOST("Host"),
    ORIGIN("Origin"),
    REFERER("Referer"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private HeaderEnum(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HeaderEnum fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(HeaderEnum.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HeaderEnum> knownValues() {
        return Stream.of(HeaderEnum.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

