/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.ContainerImage;
import software.amazon.awssdk.services.lightsail.model.ContainerImageListCopier;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetContainerImagesResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, GetContainerImagesResponse> {
    private static final SdkField<List<ContainerImage>> CONTAINER_IMAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("containerImages").getter(GetContainerImagesResponse.getter(GetContainerImagesResponse::containerImages)).setter(GetContainerImagesResponse.setter(Builder::containerImages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerImages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContainerImage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_IMAGES_FIELD));
    private final List<ContainerImage> containerImages;

    private GetContainerImagesResponse(BuilderImpl builder) {
        super(builder);
        this.containerImages = builder.containerImages;
    }

    public final boolean hasContainerImages() {
        return this.containerImages != null && !(this.containerImages instanceof SdkAutoConstructList);
    }

    public final List<ContainerImage> containerImages() {
        return this.containerImages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContainerImages() ? this.containerImages() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetContainerImagesResponse)) {
            return false;
        }
        GetContainerImagesResponse other = (GetContainerImagesResponse)((Object)obj);
        return this.hasContainerImages() == other.hasContainerImages() && Objects.equals(this.containerImages(), other.containerImages());
    }

    public final String toString() {
        return ToString.builder((String)"GetContainerImagesResponse").add("ContainerImages", this.hasContainerImages() ? this.containerImages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "containerImages": {
                return Optional.ofNullable(clazz.cast(this.containerImages()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetContainerImagesResponse, T> g) {
        return obj -> g.apply((GetContainerImagesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private List<ContainerImage> containerImages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetContainerImagesResponse model) {
            super(model);
            this.containerImages(model.containerImages);
        }

        public final List<ContainerImage.Builder> getContainerImages() {
            List<ContainerImage.Builder> result = ContainerImageListCopier.copyToBuilder(this.containerImages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder containerImages(Collection<ContainerImage> containerImages) {
            this.containerImages = ContainerImageListCopier.copy(containerImages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerImages(ContainerImage ... containerImages) {
            this.containerImages(Arrays.asList(containerImages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerImages(Consumer<ContainerImage.Builder> ... containerImages) {
            this.containerImages(Stream.of(containerImages).map(c -> (ContainerImage)((ContainerImage.Builder)ContainerImage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setContainerImages(Collection<ContainerImage.BuilderImpl> containerImages) {
            this.containerImages = ContainerImageListCopier.copyFromBuilder(containerImages);
        }

        @Override
        public GetContainerImagesResponse build() {
            return new GetContainerImagesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetContainerImagesResponse> {
        public Builder containerImages(Collection<ContainerImage> var1);

        public Builder containerImages(ContainerImage ... var1);

        public Builder containerImages(Consumer<ContainerImage.Builder> ... var1);
    }
}

