/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DiskState {
    PENDING("pending"),
    ERROR("error"),
    AVAILABLE("available"),
    IN_USE("in-use"),
    UNKNOWN("unknown"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DiskState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DiskState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DiskState.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DiskState> knownValues() {
        return Stream.of(DiskState.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

