/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.licensemanager.model.LicenseManagerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetLicenseRequest
extends LicenseManagerRequest
implements ToCopyableBuilder<Builder, GetLicenseRequest> {
    private static final SdkField<String> LICENSE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LicenseArn").getter(GetLicenseRequest.getter(GetLicenseRequest::licenseArn)).setter(GetLicenseRequest.setter(Builder::licenseArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseArn").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Version").getter(GetLicenseRequest.getter(GetLicenseRequest::version)).setter(GetLicenseRequest.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LICENSE_ARN_FIELD, VERSION_FIELD));
    private final String licenseArn;
    private final String version;

    private GetLicenseRequest(BuilderImpl builder) {
        super(builder);
        this.licenseArn = builder.licenseArn;
        this.version = builder.version;
    }

    public final String licenseArn() {
        return this.licenseArn;
    }

    public final String version() {
        return this.version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLicenseRequest)) {
            return false;
        }
        GetLicenseRequest other = (GetLicenseRequest)((Object)obj);
        return Objects.equals(this.licenseArn(), other.licenseArn()) && Objects.equals(this.version(), other.version());
    }

    public final String toString() {
        return ToString.builder((String)"GetLicenseRequest").add("LicenseArn", (Object)this.licenseArn()).add("Version", (Object)this.version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LicenseArn": {
                return Optional.ofNullable(clazz.cast(this.licenseArn()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLicenseRequest, T> g) {
        return obj -> g.apply((GetLicenseRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LicenseManagerRequest.BuilderImpl
    implements Builder {
        private String licenseArn;
        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLicenseRequest model) {
            super(model);
            this.licenseArn(model.licenseArn);
            this.version(model.version);
        }

        public final String getLicenseArn() {
            return this.licenseArn;
        }

        @Override
        public final Builder licenseArn(String licenseArn) {
            this.licenseArn = licenseArn;
            return this;
        }

        public final void setLicenseArn(String licenseArn) {
            this.licenseArn = licenseArn;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetLicenseRequest build() {
            return new GetLicenseRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LicenseManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetLicenseRequest> {
        public Builder licenseArn(String var1);

        public Builder version(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

