/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexruntime.model.LexRuntimeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PostContentRequest
extends LexRuntimeRequest
implements ToCopyableBuilder<Builder, PostContentRequest> {
    private static final SdkField<String> BOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botName").getter(PostContentRequest.getter(PostContentRequest::botName)).setter(PostContentRequest.setter(Builder::botName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("botName").build()}).build();
    private static final SdkField<String> BOT_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botAlias").getter(PostContentRequest.getter(PostContentRequest::botAlias)).setter(PostContentRequest.setter(Builder::botAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("botAlias").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userId").getter(PostContentRequest.getter(PostContentRequest::userId)).setter(PostContentRequest.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("userId").build()}).build();
    private static final SdkField<String> SESSION_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionAttributes").getter(PostContentRequest.getter(PostContentRequest::sessionAttributes)).setter(PostContentRequest.setter(Builder::sessionAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-session-attributes").build(), JsonValueTrait.create()}).build();
    private static final SdkField<String> REQUEST_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("requestAttributes").getter(PostContentRequest.getter(PostContentRequest::requestAttributes)).setter(PostContentRequest.setter(Builder::requestAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-request-attributes").build(), JsonValueTrait.create()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentType").getter(PostContentRequest.getter(PostContentRequest::contentType)).setter(PostContentRequest.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()}).build();
    private static final SdkField<String> ACCEPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accept").getter(PostContentRequest.getter(PostContentRequest::accept)).setter(PostContentRequest.setter(Builder::accept)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Accept").build()}).build();
    private static final SdkField<String> ACTIVE_CONTEXTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("activeContexts").getter(PostContentRequest.getter(PostContentRequest::activeContexts)).setter(PostContentRequest.setter(Builder::activeContexts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-active-contexts").build(), JsonValueTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_NAME_FIELD, BOT_ALIAS_FIELD, USER_ID_FIELD, SESSION_ATTRIBUTES_FIELD, REQUEST_ATTRIBUTES_FIELD, CONTENT_TYPE_FIELD, ACCEPT_FIELD, ACTIVE_CONTEXTS_FIELD));
    private final String botName;
    private final String botAlias;
    private final String userId;
    private final String sessionAttributes;
    private final String requestAttributes;
    private final String contentType;
    private final String accept;
    private final String activeContexts;

    private PostContentRequest(BuilderImpl builder) {
        super(builder);
        this.botName = builder.botName;
        this.botAlias = builder.botAlias;
        this.userId = builder.userId;
        this.sessionAttributes = builder.sessionAttributes;
        this.requestAttributes = builder.requestAttributes;
        this.contentType = builder.contentType;
        this.accept = builder.accept;
        this.activeContexts = builder.activeContexts;
    }

    public final String botName() {
        return this.botName;
    }

    public final String botAlias() {
        return this.botAlias;
    }

    public final String userId() {
        return this.userId;
    }

    public final String sessionAttributes() {
        return this.sessionAttributes;
    }

    public final String requestAttributes() {
        return this.requestAttributes;
    }

    public final String contentType() {
        return this.contentType;
    }

    public final String accept() {
        return this.accept;
    }

    public final String activeContexts() {
        return this.activeContexts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.botName());
        hashCode = 31 * hashCode + Objects.hashCode(this.botAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.accept());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeContexts());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PostContentRequest)) {
            return false;
        }
        PostContentRequest other = (PostContentRequest)((Object)obj);
        return Objects.equals(this.botName(), other.botName()) && Objects.equals(this.botAlias(), other.botAlias()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.sessionAttributes(), other.sessionAttributes()) && Objects.equals(this.requestAttributes(), other.requestAttributes()) && Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.accept(), other.accept()) && Objects.equals(this.activeContexts(), other.activeContexts());
    }

    public final String toString() {
        return ToString.builder((String)"PostContentRequest").add("BotName", (Object)this.botName()).add("BotAlias", (Object)this.botAlias()).add("UserId", (Object)this.userId()).add("SessionAttributes", (Object)(this.sessionAttributes() == null ? null : "*** Sensitive Data Redacted ***")).add("RequestAttributes", (Object)(this.requestAttributes() == null ? null : "*** Sensitive Data Redacted ***")).add("ContentType", (Object)this.contentType()).add("Accept", (Object)this.accept()).add("ActiveContexts", (Object)(this.activeContexts() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botName": {
                return Optional.ofNullable(clazz.cast(this.botName()));
            }
            case "botAlias": {
                return Optional.ofNullable(clazz.cast(this.botAlias()));
            }
            case "userId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "sessionAttributes": {
                return Optional.ofNullable(clazz.cast(this.sessionAttributes()));
            }
            case "requestAttributes": {
                return Optional.ofNullable(clazz.cast(this.requestAttributes()));
            }
            case "contentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "accept": {
                return Optional.ofNullable(clazz.cast(this.accept()));
            }
            case "activeContexts": {
                return Optional.ofNullable(clazz.cast(this.activeContexts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PostContentRequest, T> g) {
        return obj -> g.apply((PostContentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexRuntimeRequest.BuilderImpl
    implements Builder {
        private String botName;
        private String botAlias;
        private String userId;
        private String sessionAttributes;
        private String requestAttributes;
        private String contentType;
        private String accept;
        private String activeContexts;

        private BuilderImpl() {
        }

        private BuilderImpl(PostContentRequest model) {
            super(model);
            this.botName(model.botName);
            this.botAlias(model.botAlias);
            this.userId(model.userId);
            this.sessionAttributes(model.sessionAttributes);
            this.requestAttributes(model.requestAttributes);
            this.contentType(model.contentType);
            this.accept(model.accept);
            this.activeContexts(model.activeContexts);
        }

        public final String getBotName() {
            return this.botName;
        }

        @Override
        public final Builder botName(String botName) {
            this.botName = botName;
            return this;
        }

        public final void setBotName(String botName) {
            this.botName = botName;
        }

        public final String getBotAlias() {
            return this.botAlias;
        }

        @Override
        public final Builder botAlias(String botAlias) {
            this.botAlias = botAlias;
            return this;
        }

        public final void setBotAlias(String botAlias) {
            this.botAlias = botAlias;
        }

        public final String getUserId() {
            return this.userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final String getSessionAttributes() {
            return this.sessionAttributes;
        }

        @Override
        public final Builder sessionAttributes(String sessionAttributes) {
            this.sessionAttributes = sessionAttributes;
            return this;
        }

        public final void setSessionAttributes(String sessionAttributes) {
            this.sessionAttributes = sessionAttributes;
        }

        public final String getRequestAttributes() {
            return this.requestAttributes;
        }

        @Override
        public final Builder requestAttributes(String requestAttributes) {
            this.requestAttributes = requestAttributes;
            return this;
        }

        public final void setRequestAttributes(String requestAttributes) {
            this.requestAttributes = requestAttributes;
        }

        public final String getContentType() {
            return this.contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public final String getAccept() {
            return this.accept;
        }

        @Override
        public final Builder accept(String accept) {
            this.accept = accept;
            return this;
        }

        public final void setAccept(String accept) {
            this.accept = accept;
        }

        public final String getActiveContexts() {
            return this.activeContexts;
        }

        @Override
        public final Builder activeContexts(String activeContexts) {
            this.activeContexts = activeContexts;
            return this;
        }

        public final void setActiveContexts(String activeContexts) {
            this.activeContexts = activeContexts;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PostContentRequest build() {
            return new PostContentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexRuntimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PostContentRequest> {
        public Builder botName(String var1);

        public Builder botAlias(String var1);

        public Builder userId(String var1);

        public Builder sessionAttributes(String var1);

        public Builder requestAttributes(String var1);

        public Builder contentType(String var1);

        public Builder accept(String var1);

        public Builder activeContexts(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

