/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntime.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum MessageFormatType {
    PLAIN_TEXT("PlainText"),
    CUSTOM_PAYLOAD("CustomPayload"),
    SSML("SSML"),
    COMPOSITE("Composite"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private MessageFormatType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MessageFormatType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(MessageFormatType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MessageFormatType> knownValues() {
        return Stream.of(MessageFormatType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

