/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntime;

import java.nio.file.Path;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.lexruntime.DefaultLexRuntimeClientBuilder;
import software.amazon.awssdk.services.lexruntime.LexRuntimeClientBuilder;
import software.amazon.awssdk.services.lexruntime.model.BadGatewayException;
import software.amazon.awssdk.services.lexruntime.model.BadRequestException;
import software.amazon.awssdk.services.lexruntime.model.ConflictException;
import software.amazon.awssdk.services.lexruntime.model.DeleteSessionRequest;
import software.amazon.awssdk.services.lexruntime.model.DeleteSessionResponse;
import software.amazon.awssdk.services.lexruntime.model.DependencyFailedException;
import software.amazon.awssdk.services.lexruntime.model.GetSessionRequest;
import software.amazon.awssdk.services.lexruntime.model.GetSessionResponse;
import software.amazon.awssdk.services.lexruntime.model.InternalFailureException;
import software.amazon.awssdk.services.lexruntime.model.LexRuntimeException;
import software.amazon.awssdk.services.lexruntime.model.LimitExceededException;
import software.amazon.awssdk.services.lexruntime.model.LoopDetectedException;
import software.amazon.awssdk.services.lexruntime.model.NotAcceptableException;
import software.amazon.awssdk.services.lexruntime.model.NotFoundException;
import software.amazon.awssdk.services.lexruntime.model.PostContentRequest;
import software.amazon.awssdk.services.lexruntime.model.PostContentResponse;
import software.amazon.awssdk.services.lexruntime.model.PostTextRequest;
import software.amazon.awssdk.services.lexruntime.model.PostTextResponse;
import software.amazon.awssdk.services.lexruntime.model.PutSessionRequest;
import software.amazon.awssdk.services.lexruntime.model.PutSessionResponse;
import software.amazon.awssdk.services.lexruntime.model.RequestTimeoutException;
import software.amazon.awssdk.services.lexruntime.model.UnsupportedMediaTypeException;

public interface LexRuntimeClient
extends SdkClient {
    public static final String SERVICE_NAME = "lex";
    public static final String SERVICE_METADATA_ID = "runtime.lex";

    public static LexRuntimeClient create() {
        return (LexRuntimeClient)LexRuntimeClient.builder().build();
    }

    public static LexRuntimeClientBuilder builder() {
        return new DefaultLexRuntimeClientBuilder();
    }

    default public DeleteSessionResponse deleteSession(DeleteSessionRequest deleteSessionRequest) throws NotFoundException, BadRequestException, LimitExceededException, InternalFailureException, ConflictException, AwsServiceException, SdkClientException, LexRuntimeException {
        throw new UnsupportedOperationException();
    }

    default public DeleteSessionResponse deleteSession(Consumer<DeleteSessionRequest.Builder> deleteSessionRequest) throws NotFoundException, BadRequestException, LimitExceededException, InternalFailureException, ConflictException, AwsServiceException, SdkClientException, LexRuntimeException {
        return this.deleteSession((DeleteSessionRequest)((Object)((DeleteSessionRequest.Builder)DeleteSessionRequest.builder().applyMutation(deleteSessionRequest)).build()));
    }

    default public GetSessionResponse getSession(GetSessionRequest getSessionRequest) throws NotFoundException, BadRequestException, LimitExceededException, InternalFailureException, AwsServiceException, SdkClientException, LexRuntimeException {
        throw new UnsupportedOperationException();
    }

    default public GetSessionResponse getSession(Consumer<GetSessionRequest.Builder> getSessionRequest) throws NotFoundException, BadRequestException, LimitExceededException, InternalFailureException, AwsServiceException, SdkClientException, LexRuntimeException {
        return this.getSession((GetSessionRequest)((Object)((GetSessionRequest.Builder)GetSessionRequest.builder().applyMutation(getSessionRequest)).build()));
    }

    default public <ReturnT> ReturnT postContent(PostContentRequest postContentRequest, RequestBody requestBody, ResponseTransformer<PostContentResponse, ReturnT> responseTransformer) throws NotFoundException, BadRequestException, LimitExceededException, InternalFailureException, ConflictException, UnsupportedMediaTypeException, NotAcceptableException, RequestTimeoutException, DependencyFailedException, BadGatewayException, LoopDetectedException, AwsServiceException, SdkClientException, LexRuntimeException {
        throw new UnsupportedOperationException();
    }

    default public <ReturnT> ReturnT postContent(Consumer<PostContentRequest.Builder> postContentRequest, RequestBody requestBody, ResponseTransformer<PostContentResponse, ReturnT> responseTransformer) throws NotFoundException, BadRequestException, LimitExceededException, InternalFailureException, ConflictException, UnsupportedMediaTypeException, NotAcceptableException, RequestTimeoutException, DependencyFailedException, BadGatewayException, LoopDetectedException, AwsServiceException, SdkClientException, LexRuntimeException {
        return this.postContent((PostContentRequest)((Object)((PostContentRequest.Builder)PostContentRequest.builder().applyMutation(postContentRequest)).build()), requestBody, responseTransformer);
    }

    default public PostContentResponse postContent(PostContentRequest postContentRequest, Path sourcePath, Path destinationPath) throws NotFoundException, BadRequestException, LimitExceededException, InternalFailureException, ConflictException, UnsupportedMediaTypeException, NotAcceptableException, RequestTimeoutException, DependencyFailedException, BadGatewayException, LoopDetectedException, AwsServiceException, SdkClientException, LexRuntimeException {
        return (PostContentResponse)((Object)this.postContent(postContentRequest, RequestBody.fromFile((Path)sourcePath), ResponseTransformer.toFile((Path)destinationPath)));
    }

    default public PostContentResponse postContent(Consumer<PostContentRequest.Builder> postContentRequest, Path sourcePath, Path destinationPath) throws NotFoundException, BadRequestException, LimitExceededException, InternalFailureException, ConflictException, UnsupportedMediaTypeException, NotAcceptableException, RequestTimeoutException, DependencyFailedException, BadGatewayException, LoopDetectedException, AwsServiceException, SdkClientException, LexRuntimeException {
        return this.postContent((PostContentRequest)((Object)((PostContentRequest.Builder)PostContentRequest.builder().applyMutation(postContentRequest)).build()), sourcePath, destinationPath);
    }

    default public PostTextResponse postText(PostTextRequest postTextRequest) throws NotFoundException, BadRequestException, LimitExceededException, InternalFailureException, ConflictException, DependencyFailedException, BadGatewayException, LoopDetectedException, AwsServiceException, SdkClientException, LexRuntimeException {
        throw new UnsupportedOperationException();
    }

    default public PostTextResponse postText(Consumer<PostTextRequest.Builder> postTextRequest) throws NotFoundException, BadRequestException, LimitExceededException, InternalFailureException, ConflictException, DependencyFailedException, BadGatewayException, LoopDetectedException, AwsServiceException, SdkClientException, LexRuntimeException {
        return this.postText((PostTextRequest)((Object)((PostTextRequest.Builder)PostTextRequest.builder().applyMutation(postTextRequest)).build()));
    }

    default public <ReturnT> ReturnT putSession(PutSessionRequest putSessionRequest, ResponseTransformer<PutSessionResponse, ReturnT> responseTransformer) throws NotFoundException, BadRequestException, LimitExceededException, InternalFailureException, ConflictException, NotAcceptableException, DependencyFailedException, BadGatewayException, AwsServiceException, SdkClientException, LexRuntimeException {
        throw new UnsupportedOperationException();
    }

    default public <ReturnT> ReturnT putSession(Consumer<PutSessionRequest.Builder> putSessionRequest, ResponseTransformer<PutSessionResponse, ReturnT> responseTransformer) throws NotFoundException, BadRequestException, LimitExceededException, InternalFailureException, ConflictException, NotAcceptableException, DependencyFailedException, BadGatewayException, AwsServiceException, SdkClientException, LexRuntimeException {
        return this.putSession((PutSessionRequest)((Object)((PutSessionRequest.Builder)PutSessionRequest.builder().applyMutation(putSessionRequest)).build()), responseTransformer);
    }

    default public PutSessionResponse putSession(PutSessionRequest putSessionRequest, Path destinationPath) throws NotFoundException, BadRequestException, LimitExceededException, InternalFailureException, ConflictException, NotAcceptableException, DependencyFailedException, BadGatewayException, AwsServiceException, SdkClientException, LexRuntimeException {
        return (PutSessionResponse)((Object)this.putSession(putSessionRequest, ResponseTransformer.toFile((Path)destinationPath)));
    }

    default public PutSessionResponse putSession(Consumer<PutSessionRequest.Builder> putSessionRequest, Path destinationPath) throws NotFoundException, BadRequestException, LimitExceededException, InternalFailureException, ConflictException, NotAcceptableException, DependencyFailedException, BadGatewayException, AwsServiceException, SdkClientException, LexRuntimeException {
        return this.putSession((PutSessionRequest)((Object)((PutSessionRequest.Builder)PutSessionRequest.builder().applyMutation(putSessionRequest)).build()), destinationPath);
    }

    default public ResponseInputStream<PutSessionResponse> putSession(PutSessionRequest putSessionRequest) throws NotFoundException, BadRequestException, LimitExceededException, InternalFailureException, ConflictException, NotAcceptableException, DependencyFailedException, BadGatewayException, AwsServiceException, SdkClientException, LexRuntimeException {
        return (ResponseInputStream)this.putSession(putSessionRequest, ResponseTransformer.toInputStream());
    }

    default public ResponseInputStream<PutSessionResponse> putSession(Consumer<PutSessionRequest.Builder> putSessionRequest) throws NotFoundException, BadRequestException, LimitExceededException, InternalFailureException, ConflictException, NotAcceptableException, DependencyFailedException, BadGatewayException, AwsServiceException, SdkClientException, LexRuntimeException {
        return this.putSession((PutSessionRequest)((Object)((PutSessionRequest.Builder)PutSessionRequest.builder().applyMutation(putSessionRequest)).build()));
    }

    default public ResponseBytes<PutSessionResponse> putSessionAsBytes(PutSessionRequest putSessionRequest) throws NotFoundException, BadRequestException, LimitExceededException, InternalFailureException, ConflictException, NotAcceptableException, DependencyFailedException, BadGatewayException, AwsServiceException, SdkClientException, LexRuntimeException {
        return (ResponseBytes)this.putSession(putSessionRequest, ResponseTransformer.toBytes());
    }

    default public ResponseBytes<PutSessionResponse> putSessionAsBytes(Consumer<PutSessionRequest.Builder> putSessionRequest) throws NotFoundException, BadRequestException, LimitExceededException, InternalFailureException, ConflictException, NotAcceptableException, DependencyFailedException, BadGatewayException, AwsServiceException, SdkClientException, LexRuntimeException {
        return this.putSessionAsBytes((PutSessionRequest)((Object)((PutSessionRequest.Builder)PutSessionRequest.builder().applyMutation(putSessionRequest)).build()));
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)SERVICE_METADATA_ID);
    }
}

