/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lakeformation.LakeFormationClient;
import software.amazon.awssdk.services.lakeformation.model.GetEffectivePermissionsForPathRequest;
import software.amazon.awssdk.services.lakeformation.model.GetEffectivePermissionsForPathResponse;

public class GetEffectivePermissionsForPathIterable
implements SdkIterable<GetEffectivePermissionsForPathResponse> {
    private final LakeFormationClient client;
    private final GetEffectivePermissionsForPathRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetEffectivePermissionsForPathIterable(LakeFormationClient client, GetEffectivePermissionsForPathRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetEffectivePermissionsForPathResponseFetcher();
    }

    public Iterator<GetEffectivePermissionsForPathResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetEffectivePermissionsForPathResponseFetcher
    implements SyncPageFetcher<GetEffectivePermissionsForPathResponse> {
        private GetEffectivePermissionsForPathResponseFetcher() {
        }

        public boolean hasNextPage(GetEffectivePermissionsForPathResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetEffectivePermissionsForPathResponse nextPage(GetEffectivePermissionsForPathResponse previousPage) {
            if (previousPage == null) {
                return GetEffectivePermissionsForPathIterable.this.client.getEffectivePermissionsForPath(GetEffectivePermissionsForPathIterable.this.firstRequest);
            }
            return GetEffectivePermissionsForPathIterable.this.client.getEffectivePermissionsForPath((GetEffectivePermissionsForPathRequest)((Object)GetEffectivePermissionsForPathIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

