/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.kms.model.EncryptionAlgorithmSpec;
import software.amazon.awssdk.services.kms.model.EncryptionContextTypeCopier;
import software.amazon.awssdk.services.kms.model.GrantTokenListCopier;
import software.amazon.awssdk.services.kms.model.KmsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EncryptRequest
extends KmsRequest
implements ToCopyableBuilder<Builder, EncryptRequest> {
    private static final SdkField<String> KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyId").getter(EncryptRequest.getter(EncryptRequest::keyId)).setter(EncryptRequest.setter(Builder::keyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyId").build()}).build();
    private static final SdkField<SdkBytes> PLAINTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("Plaintext").getter(EncryptRequest.getter(EncryptRequest::plaintext)).setter(EncryptRequest.setter(Builder::plaintext)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Plaintext").build()}).build();
    private static final SdkField<Map<String, String>> ENCRYPTION_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("EncryptionContext").getter(EncryptRequest.getter(EncryptRequest::encryptionContext)).setter(EncryptRequest.setter(Builder::encryptionContext)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionContext").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> GRANT_TOKENS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GrantTokens").getter(EncryptRequest.getter(EncryptRequest::grantTokens)).setter(EncryptRequest.setter(Builder::grantTokens)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantTokens").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ENCRYPTION_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionAlgorithm").getter(EncryptRequest.getter(EncryptRequest::encryptionAlgorithmAsString)).setter(EncryptRequest.setter(Builder::encryptionAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionAlgorithm").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ID_FIELD, PLAINTEXT_FIELD, ENCRYPTION_CONTEXT_FIELD, GRANT_TOKENS_FIELD, ENCRYPTION_ALGORITHM_FIELD));
    private final String keyId;
    private final SdkBytes plaintext;
    private final Map<String, String> encryptionContext;
    private final List<String> grantTokens;
    private final String encryptionAlgorithm;

    private EncryptRequest(BuilderImpl builder) {
        super(builder);
        this.keyId = builder.keyId;
        this.plaintext = builder.plaintext;
        this.encryptionContext = builder.encryptionContext;
        this.grantTokens = builder.grantTokens;
        this.encryptionAlgorithm = builder.encryptionAlgorithm;
    }

    public String keyId() {
        return this.keyId;
    }

    public SdkBytes plaintext() {
        return this.plaintext;
    }

    public boolean hasEncryptionContext() {
        return this.encryptionContext != null && !(this.encryptionContext instanceof SdkAutoConstructMap);
    }

    public Map<String, String> encryptionContext() {
        return this.encryptionContext;
    }

    public boolean hasGrantTokens() {
        return this.grantTokens != null && !(this.grantTokens instanceof SdkAutoConstructList);
    }

    public List<String> grantTokens() {
        return this.grantTokens;
    }

    public EncryptionAlgorithmSpec encryptionAlgorithm() {
        return EncryptionAlgorithmSpec.fromValue(this.encryptionAlgorithm);
    }

    public String encryptionAlgorithmAsString() {
        return this.encryptionAlgorithm;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.plaintext());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEncryptionContext() ? this.encryptionContext() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGrantTokens() ? this.grantTokens() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionAlgorithmAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptRequest)) {
            return false;
        }
        EncryptRequest other = (EncryptRequest)((Object)obj);
        return Objects.equals(this.keyId(), other.keyId()) && Objects.equals(this.plaintext(), other.plaintext()) && this.hasEncryptionContext() == other.hasEncryptionContext() && Objects.equals(this.encryptionContext(), other.encryptionContext()) && this.hasGrantTokens() == other.hasGrantTokens() && Objects.equals(this.grantTokens(), other.grantTokens()) && Objects.equals(this.encryptionAlgorithmAsString(), other.encryptionAlgorithmAsString());
    }

    public String toString() {
        return ToString.builder((String)"EncryptRequest").add("KeyId", (Object)this.keyId()).add("Plaintext", (Object)(this.plaintext() == null ? null : "*** Sensitive Data Redacted ***")).add("EncryptionContext", this.hasEncryptionContext() ? this.encryptionContext() : null).add("GrantTokens", this.hasGrantTokens() ? this.grantTokens() : null).add("EncryptionAlgorithm", (Object)this.encryptionAlgorithmAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyId": {
                return Optional.ofNullable(clazz.cast(this.keyId()));
            }
            case "Plaintext": {
                return Optional.ofNullable(clazz.cast(this.plaintext()));
            }
            case "EncryptionContext": {
                return Optional.ofNullable(clazz.cast(this.encryptionContext()));
            }
            case "GrantTokens": {
                return Optional.ofNullable(clazz.cast(this.grantTokens()));
            }
            case "EncryptionAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.encryptionAlgorithmAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EncryptRequest, T> g) {
        return obj -> g.apply((EncryptRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KmsRequest.BuilderImpl
    implements Builder {
        private String keyId;
        private SdkBytes plaintext;
        private Map<String, String> encryptionContext = DefaultSdkAutoConstructMap.getInstance();
        private List<String> grantTokens = DefaultSdkAutoConstructList.getInstance();
        private String encryptionAlgorithm;

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptRequest model) {
            super(model);
            this.keyId(model.keyId);
            this.plaintext(model.plaintext);
            this.encryptionContext(model.encryptionContext);
            this.grantTokens(model.grantTokens);
            this.encryptionAlgorithm(model.encryptionAlgorithm);
        }

        public final String getKeyId() {
            return this.keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final ByteBuffer getPlaintext() {
            return this.plaintext == null ? null : this.plaintext.asByteBuffer();
        }

        @Override
        public final Builder plaintext(SdkBytes plaintext) {
            this.plaintext = StandardMemberCopier.copy((SdkBytes)plaintext);
            return this;
        }

        public final void setPlaintext(ByteBuffer plaintext) {
            this.plaintext(plaintext == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)plaintext));
        }

        public final Map<String, String> getEncryptionContext() {
            if (this.encryptionContext instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.encryptionContext;
        }

        @Override
        public final Builder encryptionContext(Map<String, String> encryptionContext) {
            this.encryptionContext = EncryptionContextTypeCopier.copy(encryptionContext);
            return this;
        }

        public final void setEncryptionContext(Map<String, String> encryptionContext) {
            this.encryptionContext = EncryptionContextTypeCopier.copy(encryptionContext);
        }

        public final Collection<String> getGrantTokens() {
            if (this.grantTokens instanceof SdkAutoConstructList) {
                return null;
            }
            return this.grantTokens;
        }

        @Override
        public final Builder grantTokens(Collection<String> grantTokens) {
            this.grantTokens = GrantTokenListCopier.copy(grantTokens);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grantTokens(String ... grantTokens) {
            this.grantTokens(Arrays.asList(grantTokens));
            return this;
        }

        public final void setGrantTokens(Collection<String> grantTokens) {
            this.grantTokens = GrantTokenListCopier.copy(grantTokens);
        }

        public final String getEncryptionAlgorithm() {
            return this.encryptionAlgorithm;
        }

        @Override
        public final Builder encryptionAlgorithm(String encryptionAlgorithm) {
            this.encryptionAlgorithm = encryptionAlgorithm;
            return this;
        }

        @Override
        public final Builder encryptionAlgorithm(EncryptionAlgorithmSpec encryptionAlgorithm) {
            this.encryptionAlgorithm(encryptionAlgorithm == null ? null : encryptionAlgorithm.toString());
            return this;
        }

        public final void setEncryptionAlgorithm(String encryptionAlgorithm) {
            this.encryptionAlgorithm = encryptionAlgorithm;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EncryptRequest build() {
            return new EncryptRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KmsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, EncryptRequest> {
        public Builder keyId(String var1);

        public Builder plaintext(SdkBytes var1);

        public Builder encryptionContext(Map<String, String> var1);

        public Builder grantTokens(Collection<String> var1);

        public Builder grantTokens(String ... var1);

        public Builder encryptionAlgorithm(String var1);

        public Builder encryptionAlgorithm(EncryptionAlgorithmSpec var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

