/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideo.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kinesisvideo.KinesisVideoAsyncClient;
import software.amazon.awssdk.services.kinesisvideo.model.ChannelInfo;
import software.amazon.awssdk.services.kinesisvideo.model.ListSignalingChannelsRequest;
import software.amazon.awssdk.services.kinesisvideo.model.ListSignalingChannelsResponse;

public class ListSignalingChannelsPublisher
implements SdkPublisher<ListSignalingChannelsResponse> {
    private final KinesisVideoAsyncClient client;
    private final ListSignalingChannelsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSignalingChannelsPublisher(KinesisVideoAsyncClient client, ListSignalingChannelsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSignalingChannelsPublisher(KinesisVideoAsyncClient client, ListSignalingChannelsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSignalingChannelsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSignalingChannelsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ChannelInfo> channelInfoList() {
        Function<ListSignalingChannelsResponse, Iterator> getIterator = response -> {
            if (response != null && response.channelInfoList() != null) {
                return response.channelInfoList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSignalingChannelsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSignalingChannelsResponseFetcher
    implements AsyncPageFetcher<ListSignalingChannelsResponse> {
        private ListSignalingChannelsResponseFetcher() {
        }

        public boolean hasNextPage(ListSignalingChannelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSignalingChannelsResponse> nextPage(ListSignalingChannelsResponse previousPage) {
            if (previousPage == null) {
                return ListSignalingChannelsPublisher.this.client.listSignalingChannels(ListSignalingChannelsPublisher.this.firstRequest);
            }
            return ListSignalingChannelsPublisher.this.client.listSignalingChannels((ListSignalingChannelsRequest)((Object)ListSignalingChannelsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

