/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesis.model.KinesisResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLimitsResponse
extends KinesisResponse
implements ToCopyableBuilder<Builder, DescribeLimitsResponse> {
    private static final SdkField<Integer> SHARD_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DescribeLimitsResponse.getter(DescribeLimitsResponse::shardLimit)).setter(DescribeLimitsResponse.setter(Builder::shardLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShardLimit").build()}).build();
    private static final SdkField<Integer> OPEN_SHARD_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DescribeLimitsResponse.getter(DescribeLimitsResponse::openShardCount)).setter(DescribeLimitsResponse.setter(Builder::openShardCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenShardCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARD_LIMIT_FIELD, OPEN_SHARD_COUNT_FIELD));
    private final Integer shardLimit;
    private final Integer openShardCount;

    private DescribeLimitsResponse(BuilderImpl builder) {
        super(builder);
        this.shardLimit = builder.shardLimit;
        this.openShardCount = builder.openShardCount;
    }

    public Integer shardLimit() {
        return this.shardLimit;
    }

    public Integer openShardCount() {
        return this.openShardCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.shardLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.openShardCount());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLimitsResponse)) {
            return false;
        }
        DescribeLimitsResponse other = (DescribeLimitsResponse)((Object)obj);
        return Objects.equals(this.shardLimit(), other.shardLimit()) && Objects.equals(this.openShardCount(), other.openShardCount());
    }

    public String toString() {
        return ToString.builder((String)"DescribeLimitsResponse").add("ShardLimit", (Object)this.shardLimit()).add("OpenShardCount", (Object)this.openShardCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ShardLimit": {
                return Optional.ofNullable(clazz.cast(this.shardLimit()));
            }
            case "OpenShardCount": {
                return Optional.ofNullable(clazz.cast(this.openShardCount()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLimitsResponse, T> g) {
        return obj -> g.apply((DescribeLimitsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisResponse.BuilderImpl
    implements Builder {
        private Integer shardLimit;
        private Integer openShardCount;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLimitsResponse model) {
            super(model);
            this.shardLimit(model.shardLimit);
            this.openShardCount(model.openShardCount);
        }

        public final Integer getShardLimit() {
            return this.shardLimit;
        }

        @Override
        public final Builder shardLimit(Integer shardLimit) {
            this.shardLimit = shardLimit;
            return this;
        }

        public final void setShardLimit(Integer shardLimit) {
            this.shardLimit = shardLimit;
        }

        public final Integer getOpenShardCount() {
            return this.openShardCount;
        }

        @Override
        public final Builder openShardCount(Integer openShardCount) {
            this.openShardCount = openShardCount;
            return this;
        }

        public final void setOpenShardCount(Integer openShardCount) {
            this.openShardCount = openShardCount;
        }

        @Override
        public DescribeLimitsResponse build() {
            return new DescribeLimitsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeLimitsResponse> {
        public Builder shardLimit(Integer var1);

        public Builder openShardCount(Integer var1);
    }
}

