/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotthingsgraph.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotthingsgraph.IoTThingsGraphClient;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchThingsRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchThingsResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.Thing;

public class SearchThingsIterable
implements SdkIterable<SearchThingsResponse> {
    private final IoTThingsGraphClient client;
    private final SearchThingsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchThingsIterable(IoTThingsGraphClient client, SearchThingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new SearchThingsResponseFetcher();
    }

    public Iterator<SearchThingsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Thing> things() {
        Function<SearchThingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.things() != null) {
                return response.things().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchThingsResponseFetcher
    implements SyncPageFetcher<SearchThingsResponse> {
        private SearchThingsResponseFetcher() {
        }

        public boolean hasNextPage(SearchThingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchThingsResponse nextPage(SearchThingsResponse previousPage) {
            if (previousPage == null) {
                return SearchThingsIterable.this.client.searchThings(SearchThingsIterable.this.firstRequest);
            }
            return SearchThingsIterable.this.client.searchThings((SearchThingsRequest)((Object)SearchThingsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

