/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotthingsgraph.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotthingsgraph.IoTThingsGraphClient;
import software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionSummary;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowExecutionsRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowExecutionsResponse;

public class SearchFlowExecutionsIterable
implements SdkIterable<SearchFlowExecutionsResponse> {
    private final IoTThingsGraphClient client;
    private final SearchFlowExecutionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchFlowExecutionsIterable(IoTThingsGraphClient client, SearchFlowExecutionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new SearchFlowExecutionsResponseFetcher();
    }

    public Iterator<SearchFlowExecutionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FlowExecutionSummary> summaries() {
        Function<SearchFlowExecutionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.summaries() != null) {
                return response.summaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchFlowExecutionsResponseFetcher
    implements SyncPageFetcher<SearchFlowExecutionsResponse> {
        private SearchFlowExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(SearchFlowExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchFlowExecutionsResponse nextPage(SearchFlowExecutionsResponse previousPage) {
            if (previousPage == null) {
                return SearchFlowExecutionsIterable.this.client.searchFlowExecutions(SearchFlowExecutionsIterable.this.firstRequest);
            }
            return SearchFlowExecutionsIterable.this.client.searchFlowExecutions((SearchFlowExecutionsRequest)((Object)SearchFlowExecutionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

