/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.AssetHierarchyInfo;
import software.amazon.awssdk.services.iotsitewise.model.AssetRelationshipType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssetRelationshipSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssetRelationshipSummary> {
    private static final SdkField<AssetHierarchyInfo> HIERARCHY_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("hierarchyInfo").getter(AssetRelationshipSummary.getter(AssetRelationshipSummary::hierarchyInfo)).setter(AssetRelationshipSummary.setter(Builder::hierarchyInfo)).constructor(AssetHierarchyInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hierarchyInfo").build()}).build();
    private static final SdkField<String> RELATIONSHIP_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("relationshipType").getter(AssetRelationshipSummary.getter(AssetRelationshipSummary::relationshipTypeAsString)).setter(AssetRelationshipSummary.setter(Builder::relationshipType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationshipType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HIERARCHY_INFO_FIELD, RELATIONSHIP_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final AssetHierarchyInfo hierarchyInfo;
    private final String relationshipType;

    private AssetRelationshipSummary(BuilderImpl builder) {
        this.hierarchyInfo = builder.hierarchyInfo;
        this.relationshipType = builder.relationshipType;
    }

    public final AssetHierarchyInfo hierarchyInfo() {
        return this.hierarchyInfo;
    }

    public final AssetRelationshipType relationshipType() {
        return AssetRelationshipType.fromValue(this.relationshipType);
    }

    public final String relationshipTypeAsString() {
        return this.relationshipType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hierarchyInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.relationshipTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetRelationshipSummary)) {
            return false;
        }
        AssetRelationshipSummary other = (AssetRelationshipSummary)obj;
        return Objects.equals(this.hierarchyInfo(), other.hierarchyInfo()) && Objects.equals(this.relationshipTypeAsString(), other.relationshipTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AssetRelationshipSummary").add("HierarchyInfo", (Object)this.hierarchyInfo()).add("RelationshipType", (Object)this.relationshipTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "hierarchyInfo": {
                return Optional.ofNullable(clazz.cast(this.hierarchyInfo()));
            }
            case "relationshipType": {
                return Optional.ofNullable(clazz.cast(this.relationshipTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssetRelationshipSummary, T> g) {
        return obj -> g.apply((AssetRelationshipSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AssetHierarchyInfo hierarchyInfo;
        private String relationshipType;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetRelationshipSummary model) {
            this.hierarchyInfo(model.hierarchyInfo);
            this.relationshipType(model.relationshipType);
        }

        public final AssetHierarchyInfo.Builder getHierarchyInfo() {
            return this.hierarchyInfo != null ? this.hierarchyInfo.toBuilder() : null;
        }

        @Override
        public final Builder hierarchyInfo(AssetHierarchyInfo hierarchyInfo) {
            this.hierarchyInfo = hierarchyInfo;
            return this;
        }

        public final void setHierarchyInfo(AssetHierarchyInfo.BuilderImpl hierarchyInfo) {
            this.hierarchyInfo = hierarchyInfo != null ? hierarchyInfo.build() : null;
        }

        public final String getRelationshipType() {
            return this.relationshipType;
        }

        @Override
        public final Builder relationshipType(String relationshipType) {
            this.relationshipType = relationshipType;
            return this;
        }

        @Override
        public final Builder relationshipType(AssetRelationshipType relationshipType) {
            this.relationshipType(relationshipType == null ? null : relationshipType.toString());
            return this;
        }

        public final void setRelationshipType(String relationshipType) {
            this.relationshipType = relationshipType;
        }

        public AssetRelationshipSummary build() {
            return new AssetRelationshipSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssetRelationshipSummary> {
        public Builder hierarchyInfo(AssetHierarchyInfo var1);

        default public Builder hierarchyInfo(Consumer<AssetHierarchyInfo.Builder> hierarchyInfo) {
            return this.hierarchyInfo((AssetHierarchyInfo)((AssetHierarchyInfo.Builder)AssetHierarchyInfo.builder().applyMutation(hierarchyInfo)).build());
        }

        public Builder relationshipType(String var1);

        public Builder relationshipType(AssetRelationshipType var1);
    }
}

