/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotdataplane.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotdataplane.model.IotDataPlaneRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PublishRequest
extends IotDataPlaneRequest
implements ToCopyableBuilder<Builder, PublishRequest> {
    private static final SdkField<String> TOPIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("topic").getter(PublishRequest.getter(PublishRequest::topic)).setter(PublishRequest.setter(Builder::topic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("topic").build()}).build();
    private static final SdkField<Integer> QOS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("qos").getter(PublishRequest.getter(PublishRequest::qos)).setter(PublishRequest.setter(Builder::qos)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("qos").build()}).build();
    private static final SdkField<SdkBytes> PAYLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("payload").getter(PublishRequest.getter(PublishRequest::payload)).setter(PublishRequest.setter(Builder::payload)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payload").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPIC_FIELD, QOS_FIELD, PAYLOAD_FIELD));
    private final String topic;
    private final Integer qos;
    private final SdkBytes payload;

    private PublishRequest(BuilderImpl builder) {
        super(builder);
        this.topic = builder.topic;
        this.qos = builder.qos;
        this.payload = builder.payload;
    }

    public final String topic() {
        return this.topic;
    }

    public final Integer qos() {
        return this.qos;
    }

    public final SdkBytes payload() {
        return this.payload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.topic());
        hashCode = 31 * hashCode + Objects.hashCode(this.qos());
        hashCode = 31 * hashCode + Objects.hashCode(this.payload());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublishRequest)) {
            return false;
        }
        PublishRequest other = (PublishRequest)((Object)obj);
        return Objects.equals(this.topic(), other.topic()) && Objects.equals(this.qos(), other.qos()) && Objects.equals(this.payload(), other.payload());
    }

    public final String toString() {
        return ToString.builder((String)"PublishRequest").add("Topic", (Object)this.topic()).add("Qos", (Object)this.qos()).add("Payload", (Object)this.payload()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "topic": {
                return Optional.ofNullable(clazz.cast(this.topic()));
            }
            case "qos": {
                return Optional.ofNullable(clazz.cast(this.qos()));
            }
            case "payload": {
                return Optional.ofNullable(clazz.cast(this.payload()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PublishRequest, T> g) {
        return obj -> g.apply((PublishRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotDataPlaneRequest.BuilderImpl
    implements Builder {
        private String topic;
        private Integer qos;
        private SdkBytes payload;

        private BuilderImpl() {
        }

        private BuilderImpl(PublishRequest model) {
            super(model);
            this.topic(model.topic);
            this.qos(model.qos);
            this.payload(model.payload);
        }

        public final String getTopic() {
            return this.topic;
        }

        @Override
        public final Builder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public final void setTopic(String topic) {
            this.topic = topic;
        }

        public final Integer getQos() {
            return this.qos;
        }

        @Override
        public final Builder qos(Integer qos) {
            this.qos = qos;
            return this;
        }

        public final void setQos(Integer qos) {
            this.qos = qos;
        }

        public final ByteBuffer getPayload() {
            return this.payload == null ? null : this.payload.asByteBuffer();
        }

        @Override
        public final Builder payload(SdkBytes payload) {
            this.payload = payload;
            return this;
        }

        public final void setPayload(ByteBuffer payload) {
            this.payload(payload == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)payload));
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PublishRequest build() {
            return new PublishRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotDataPlaneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PublishRequest> {
        public Builder topic(String var1);

        public Builder qos(Integer var1);

        public Builder payload(SdkBytes var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

